package edu.buffalo.nsf.hippo.util;


import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.MultiMap;
/** 
 * <code>MultiMapImpl</code> is a special implementation of the 
 * {@link org.apache.commons.collections.MultiMap MultiMap} interface.
 * A <code>MultiMap</code> is a Map with slightly different semantics.
 * Instead of returning an Object, it returns a Collection.
 * So for example, you can put( key, new Integer(1) ); 
 * and then a Object get( key ); will return you a Collection 
 * instead of an Integer.
 * This implementation of <code>MultiMap</code> returns a Set, and therefore
 * duplicates of elements contained under a particular key are ignored.
 * @author  <a href="mailto:staworko@cse.buffalo.edu">Slawomir Staworko</a>
 */

public class MultiMapImpl extends HashMap implements MultiMap
{
    private static final long serialVersionUID = -7127480159804624857L;

	public MultiMapImpl (int initialCapacity)
    {
        super(initialCapacity);
    }

    public Object put (Object key, Object value)
    {
        Set values = (Set) get(key);

        if (values == null) {
            values = Util.createSet(1);
            super.put(key,values);
        }

        boolean duplicate = values.add(value);
        
        return (duplicate) ? (value) : (null);
    }
    
    public boolean containsValue (Object value)
    {
        Set pairs = super.entrySet();
        
        if (pairs == null) {
            return false;
        }
        
        Iterator iter = pairs.iterator();

        while (iter.hasNext()) {
            Map.Entry pair = (Map.Entry) iter.next();
            Set values = (Set) pair.getValue();
            if (values.contains(value)) {
                return true;

            }
        }

        return false;
    }
    
    public Object remove (Object key, Object item)
    {
        Set values = (Set) super.get(key);
        
        if (values == null)
            return null;
        
        boolean contained = values.remove( item );

        return (contained) ? (item) : (null);
    }
    
    public Collection values()
    {
        Set values = Util.createSet(super.size());
        
        Set pairs = super.entrySet();

        Iterator iter = pairs.iterator();

        while (iter.hasNext()) {
            Map.Entry pair = (Map.Entry) iter.next();
            Set       vals = (Set)   pair.getValue();

            //logger.debug("adding elems:" + vals);
            
            values.addAll(vals);
        }

        return values;
    }    
}
