package edu.buffalo.nsf.hippo.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Engine;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.DataSourceError;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
import edu.buffalo.nsf.hippo.parser.ParseException;

/**
 *  Returns query answers instead of consistent query answers.
 */
public class SQLEngine implements Engine
{
    protected static Logger logger = Logger.getLogger(SQLEngine.class);
    
    protected Environment env;
    protected Connection  db;

    public SQLEngine(Environment env)
    {
        this.env = env;
    }

    public void init(Configuration config)
    {
        this.db = env.getConnection(config);
    }

    public void reinit(Configuration config)
    {
    }

    public void shutdown()
    {
        env.release(db);
    }

    public TupleStream getConsistentAnswer(String sqlQuery) throws ParseException
    {
        try {
            Statement stmt = db.createStatement();

            logger.debug("SQLEngine executing query: " + sqlQuery);

            ResultSet rs = stmt.executeQuery(sqlQuery);

            TupleStream result = TupleStream.create(rs,stmt);

            logger.debug("Query result: "  + result);

            return result;
        } catch (SQLException exc) {
            logger.error("Exception caught.",exc);
            throw new DataSourceError("SQLException caught",exc);
        }        
    }
}
