package edu.buffalo.nsf.hippo.util;

import java.util.Iterator;
import java.util.Map;

public class SimpleStats extends Stats
{
    protected String name;
    protected Map    readings;

    public SimpleStats(String name)
    {
        this.name = name;
        this.readings = Util.createMap();
    }

    public String getName ()
    {
        return name;
    }
    
    public double read(Object category)
    {
        try {
            return ((Double) readings.get(category)).doubleValue();
        } catch (NullPointerException exc) {
            return 0.0;
        }
    }

    public double reset(Object category)
    {
        double old = read(category);

        readings.put(category,new Double(0));

        return old;
    }

    public double remove(Object category)
    {
        double old = read(category);

        readings.remove(category);

        return old;
    }
    
    public double touch(Object category, double factor)
    {
        double reading = read(category) + factor;

        readings.put(category,new Double(reading));

        return reading;
    }

    public Map getReadings()
    {
        return Util.createMap(readings);
    }

    public Iterator getCategories()
    {
        return readings.keySet().iterator();
    }

}
