package edu.buffalo.nsf.hippo.util;

import java.util.Iterator;
import java.util.Map;


/**
 *  A class responsible for keeping the register of 
 *  events quantity. 
 */
public abstract class Stats
{
    public static final String ENVELOPE_TUPLES = "Tuples in envelope";
    public static final String GOOD_TUPLES     = "Consistent tuples from envelope";
    public static final String BAD_TUPLES      = "Tuples inconsistent in envelope";
    public static final String QUERIES_EXEC    = "Queries executed";
    public static final String TUPLES_FROM_DB  = "Records transmited from database";
    public static final String FST_PHASE_CHECK = "Consistency decided in heuristics";
    public static final String SND_PHASE_CHECK = "Unknown consistency in heuristics";


    public static final String HYPERGRAPH_STATS = "Hypergraph statistics";
    public static final String ROOT_STATS       = "Main statistics";
        
    
    public static Stats getRootStats()
    {
        return StatsManager.getRootStats();
    }

    public static Stats getStats(String name)
    {
        return StatsManager.getStats(name);
    }

    public abstract double read   (Object category);
    public abstract double reset  (Object category);
    public abstract double remove (Object category);
    public abstract double touch  (Object category, double factor);

    public abstract String getName     ();
    public abstract Map    getReadings ();

    public Iterator getCategories()
    {
        return getReadings().keySet().iterator();
    }

    public double touch (Object category)
    {
        return touch(category,1f);
    }

    public String toString()
    {
        return "Stats(" + getName() + ") = " + getReadings();
    }

    public String toXMLString()
    {
        String result = "<stats ";
        
        if (getName() != null) {
            result += "name=\"" + FormatUtil.escapeXML(getName()) + "\"";
        }
        result += ">\n";

        Iterator categories = getCategories();

        while (categories.hasNext()) {
            Object category = categories.next();

            result += "<category " + 
                "name=\"" + FormatUtil.escapeXML(category.toString()) + "\" " +
                "reading=\"" + FormatUtil.escapeXML(""+ ((int) read(category))) + "\" "+ 
                "/>\n";
        }

        result += "</stats>";

        return result;
    }
}
