package edu.buffalo.nsf.hippo.util;

import java.util.Iterator;
import java.util.Map;

public class StatsWrapper extends Stats
{
    protected Stats parent;
    protected Stats stats;

    public StatsWrapper(Stats parent, Stats stats)
    {
        this.parent = parent;
        this.stats  = stats;
    }

    public String getName ()
    {
        return stats.getName();
    }
    
    public double read(Object category)
    {
        return stats.read(category);
    }

    public double reset(Object category)
    {
        return stats.reset(category);
    }

    public double remove(Object category)
    {
        return stats.remove(category);
    }
    
    public double touch(Object category, double factor)
    {
        parent.touch(category,factor);

        return stats.touch(category,factor);
    }

    public Map getReadings()
    {
        return stats.getReadings();
    }

    public Iterator getCategories()
    {
        return stats.getCategories();
    }

}
