/** Adam Badawy */

using namespace std;

#include <iostream>
#include <string>
#include <vector>

class StringDeque {

	public:

	vector<string>* elements;
	int frontItem;
	int rearSpace;
	int upperBound;

	StringDeque(int guaranteedCapacity) : elements(new vector<string>(2 * guaranteedCapacity)), frontItem(guaranteedCapacity), rearSpace(guaranteedCapacity), upperBound(2 * guaranteedCapacity) { }

	virtual bool isEmpty() const {return frontItem == rearSpace;}
	virtual bool isFull() const {return rearSpace == upperBound || frontItem == 0;}
	virtual int size() const {return rearSpace - frontItem;}

	virtual string popRear() {
		if (isEmpty()) {
			cout << "Later we'll define and throw an EmptyQException" << endl;
			return "";
		} else {
			return elements->at(--rearSpace);
		}
	}

	virtual string popFront() {
		if (isEmpty()) {
			cout << "Later we'll define and throw an EmptyQException" << endl;
			return "";
		} else {
			return elements->at(frontItem++);
		}
	}

	virtual void pushFront(string newItem) {
		elements->at(--frontItem) = newItem;
	}

	virtual void pushRear(string newItem) {
		elements->at(rearSpace++) = newItem;
	}

	virtual string toString() {
		string out = "";
		for (int i = frontItem; i < rearSpace; i++) {
			out += elements->at(i) + " ";
		}
		return out;
	}
};

int main() {
	StringDeque* sd = new StringDeque(100);
	sd->pushFront("oh");
	sd->pushFront("say");
	sd->pushFront("can");
	sd->pushFront("you");
	sd->pushFront("see");
	sd->pushRear("any");
	sd->pushRear("bad bugs");
	sd->pushRear("on");
	sd->pushRear("me?");
	cout << sd->toString() << endl;
	string pop2 = sd->popRear() + " " + sd->popRear();
	cout << pop2 + ", did this print in the right order?" << endl;
	sd->pushFront("I");
	cout << "Final deque: " + sd->toString() << endl;

	return 0;
};

/** REPORT QUESTION

Java output:
see you can say oh any bad bugs on me? 
me? on, did this print in the right order?
Final deque: I see you can say oh any bad bugs 

C++ output:
see you can say oh any bad bugs on me?
on me?, did this print in the right order?
Final deque: I see you can say oh any bad bugs


As you can see, the only difference between the two outputs was the exchange of the substrings "on" and "me?" on the second print line.

My best guess for an explanation would be that Java is guaranteed to execute method calls from left to right on the right side of an assignment (at least in the case of Strings), whereas C++ takes no such precaution.

*/
