#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <vector>

using namespace std;

#include "StackPairANB.h"
#include "ValliANB.h"

string wordTurn(string word) {
    StackPairANB<char>* deque = new StackPairANB<char>(word.length() * 2);

    int l = 0;
    int r = word.length();

    if (word.length() % 2 == 1) {
        deque->pushFront(word.at(word.length() / 2));
    }

    // ENS every letter of the word will be added to deck before the loop exits.
    while (l < word.length() / 2) {
        deque->pushFront(word.at(l++));
        deque->pushRear(word.at(--r));
    }
    stringstream out;

    // LOOP INVAR popFront is never called on the deque when it is empty.
    // ENS the deque will be empty when the loop finishes, and thus every 
    //     letter of the word will be included.
    while (!deque->isEmpty()) {
        out << deque->popFront();
    }

    return out.str();
};

int main(int argC, char* argV[])
{
	if (argC > 1)
	{
		ifstream fin(argV[1]);
		if (fin.is_open())
		{
			vector<string> original_words;
			Valli<string> turned_words;
			while (!fin.eof())
			{
				string word;
				fin >> word;
				if (word.length() > 3)
				{
					original_words.push_back(word);
					string turned = wordTurn(word);
					turned_words.insert(turned);
				}
			}
			fin.close();

			ofstream fout("intersect.txt");
			for (size_t i = 0; i < turned_words.size(); i++)
				fout << turned_words.get(i) << endl;
			fout.close();
		}
	}
	return 0;
}


