#include <cstdlib>
#include <iostream>
#include <fstream>
#include <set>
#include "StackPairANB.h"

using namespace std;

string wordTurn(string word) {
    StackPairANB<char>* deque = new StackPairANB<char>(word.length() * 2);
    
    int l = 0;
    int r = word.length();
    
    if (word.length() % 2 == 1) {
        deque->pushFront(word.at(word.length() / 2));
    }

    while (l < word.length() / 2) {
        deque->pushFront(word.at(l++));
        deque->pushRear(word.at(--r));
    }
    
    stringstream out;
    while (!deque->isEmpty()) {
        out << deque->popFront();
    }
    
    return out.str();
};

bool binsearch(const vector<string>& words, const string& word) {
    string newWord = wordTurn(word);
    
    if (words.empty()) {
        return false;
    }
    
    int firstItem = 0;
    int lastSpace = words.size();
    int middle,comp;
    
    while (firstItem < lastSpace) {
        middle = (firstItem + lastSpace) / 2;
        comp = newWord.compare(words[middle]);
        
        if (comp == 0) {
            return true;
        } else if (comp < 0) {
            firstItem = middle;
        } else {
            lastSpace = middle;
        }
    }
    
    return false;
}

int main(int argc, char* argv[]) {
    if (argc == 1) {
        cout << "Specific the name of an input file as an argument." << endl;
        return 0;
    }
    
    vector<string> tw;
    ifstream fin(argv[1]);
    ofstream pair;
    pair.open("pair.txt");
    string line;
    
    if (fin.is_open()) {
        while (!fin.eof()) {
            getline(fin,line);
            if (line.length() < 4) {
                if (binsearch(tw,line)) {
                    pair << line << " " << wordTurn(line) << endl;
                } else {
                    tw.push_back(line);
                }
            }
        }
        fin.close();
        pair.close();
    } else {
        cout << "Couldn't find specified file." << endl;
    }
    
    return 0;
}
