#include <fstream>
#include <iostream>
#include <string>
#include <sstream>

#include "ValliANB.h"

void processCommand(std::string line, Valli<string>* valli)
{
    std::stringstream cmd;
    std::stringstream arg;
    bool onCommand = true;

    for (size_t i = 0; i < line.length(); i++)
    {
        if (line[i] == ' ') {onCommand = false; i++;}
        if (onCommand) {cmd << line[i];} else {arg << line[i];}
    }

    std::string command = cmd.str();
    std::string argument = arg.str();

    if (command == "insert") {valli->insert(argument);}
    else if (command == "find") {valli->find(argument);}
    else if (command == "erase") {valli->erase(argument);}
    else if (command == "print") {std::cout << valli->str() << endl;}
}

int main(int argc, char* argv[])
{
    if (argc > 1)
    {
        Valli<std::string>* words;
        words->insert("poop");

        /*
        std::ifstream fin(argv[1]);

        std::string line;
        while (!fin.eof())
        {
            std::getline(fin,line);
            processCommand(line,words);
        }

        fin.close();
        */
    }
    else
    {
        std::cout << "Usage: Pass in the name of a text file containing ";
        std::cout << "commands to execute." << endl;
    }

    return 0;
}

