#include <iostream>
#include <string>
#include <sstream>
#include "TwoStacksANB.h"
using namespace std;

int main(int argc, char **argv) {
    if (argc > 1) {
        string* input = new string(*(argv+1));
        TwoStacksANB* deque = new TwoStacksANB(input->length() * 2);
        
        // Ensure the middle letter (if we have one) is placed in the middle:
        if (input->length() % 2 == 1) {
            deque->pushFront(input->at(input->length() / 2));
        }
        
        int l,r;
        l = 0; // Loop INVAR int l represents the index of the next char, iterating forwards from the left side of the string.
        r = input->length(); // Loop INVAR int r represents the index right of the next char, iterating backwards from the right side of the string.
        
        while (l < input->length() / 2) {
            deque->pushFront(input->at(l++));
            deque->pushRear(input->at(--r));
        }

        // We could print directly from the data structure:
        // cout << deque->toString() << endl;

        // Or we can retrieve the string of characters like so:
        stringstream output;
        int i = 0;
        while (!deque->isEmpty()) {
            output << deque->popFront();
        }

        cout << output.str() << endl;

    } else {
        cout << "Use a word as a command-line argument to flip it inside-out." << endl;
    }

    return 0;
};
