/* Client code file for Project 2 by AJC and JJZ
*/

#include<string>
#include<vector>
#include<iostream>
#include<map>

#include "MovieAJC.h"
#include "MovieBaseAJC.h"
#include "UserJJZ.h"
#include "UserBaseJJZ.h"


using namespace std;

const string userFile  = "u.data";
const string movieFile = "u.item";

int main(int argc, char** argv)
{
	UserDatabase* userBase = new UserDatabase();
	MovieBase* movieBase = new MovieBase();

	userBase->inputData(userFile);
	movieBase->processMovies(movieFile);

	//------------------------------
	//Create averages for each genre
	//------------------------------

	vector<float> runningTotals;
	runningTotals.resize(7);
	vector<int> runningCount;
	runningCount.resize(7);

	vector<size_t> movieGenres;
	float movieAverage;

	for (map<size_t, Movie>::iterator itr = movieBase->movies.begin(); itr != movieBase->movies.end(); ++itr)
	{
		movieAverage = userBase->getMovieAvgRating(itr->first);
		movieGenres = movieBase->getGenresOfMovie(itr->first);
		for (vector<size_t>::iterator itr2 = movieGenres.begin(); itr2 != movieGenres.end(); ++itr2)
		{
			runningTotals.at(*itr2) += movieAverage;
			runningCount.at(*itr2) += 1;
		}
	}

	for(int i = 0; i < 7; i++)
	{
		movieBase->setGenreAverage(i, runningTotals.at(i) / runningCount.at(i));
	}

	//---------------------------------------
	//Create averages for each genre per user
	//---------------------------------------

	std::vector<int> genreTotal;
	genreTotal.resize(7);
	std::vector<int> genreCount;
	genreCount.resize(7);
	std::vector<float> genreFinal;
	genreFinal.resize(7);
	std::vector<float> Userpreference;
	Userpreference.resize(7);
	std::vector<size_t> moviegenre;
	std::vector<User*>::iterator itr;
	map<int,int>::iterator itr2;
	std::vector<size_t>::iterator itr3;
	for (itr = userBase->Udatabase.begin(); itr != userBase->Udatabase.end(); ++itr)
	{
		for (itr2 = (*itr)->Reviews.begin(); itr2 != (*itr)->Reviews.end(); ++itr2)
		{
			moviegenre = movieBase->getGenresOfMovie(itr2->first);
			for (itr3 = moviegenre.begin(); itr3 != moviegenre.end(); ++itr3)
			{
				genreTotal.at((*itr3)) += (*itr)->getRating(itr2->first);
				genreCount.at((*itr3)) += 1;
			}
		}
		for ( int i =0; i!=7; ++i)
		{
		    if ( genreCount.at(i) == 0 ) {
                genreFinal.at(i) = 0;
                Userpreference.at(i) = 1;
		    } else {
			genreFinal.at(i) = genreTotal.at(i) / (float)genreCount.at(i);
			Userpreference.at(i) = genreFinal.at(i) / movieBase->getGenreAverage(i);
		    }
		}
		(*itr)->genreAverage = genreFinal;
		(*itr)->preference = Userpreference;
		std::fill(genreTotal.begin(), genreTotal.end(), 0);
		std::fill(genreCount.begin(), genreCount.end(), 0);
		std::fill(genreFinal.begin(), genreFinal.end(), 0);
		std::fill(Userpreference.begin(), Userpreference.end(), 0);
	}

    //-------------------
    //Create top 50 lists
    //-------------------
    float runningTotal2 = 0;
    float runningCount2 = 0;
    float movieScore = 0;
    int counter = 0;
    int numUser = userBase->Udatabase.size();
    map<float, size_t> top50 = map<float, size_t>();

    for (vector<User*>::iterator userItr = userBase->Udatabase.begin(); userItr != userBase->Udatabase.end(); ++userItr)
	{
	    cout << numUser - counter << endl;
	    counter++;
	    for (map<size_t, Movie>::iterator movieItr = movieBase->movies.begin(); movieItr != movieBase->movies.end(); ++movieItr)
        {
            float curMovieAverageRating = userBase->getMovieAvgRating(movieItr->first);
            vector<size_t> genreRatings = movieBase->getGenresOfMovie(movieItr->first);
            for(vector<size_t>::iterator genreItr = genreRatings.begin(); genreItr != genreRatings.end(); ++genreItr)
            {
                runningTotal2 += curMovieAverageRating * (*userItr)->preference.at((*genreItr));
                runningCount2++;
            }
            movieScore = runningTotal2 / runningCount2;
            runningCount2 = 0;
            runningTotal2 = 0;

            top50.insert(make_pair(movieScore, movieItr->first));

            if(top50.size() > 50) {
                top50.erase(top50.begin());
            }
        }
        (*userItr)->top50 = top50;
	}

	cout << userBase->Udatabase.at(1)->top50.at(0) << endl;

	return 0;
}

