/** File "DequeTestAJC.cpp", by AJC.
Translated from "DequeTest.java" by KWR
 */

#include <iostream>
#include <string>
#include <vector>

using namespace std;

class StringDeque   //Front of deque is toward 0, but need not be 0.
{
    vector<string>* elements;
    int frontItem;   //CLASS INV: indexes item with least index
    int rearSpace;   //CLASS INV: indexes space after item with greatest index
    int upperBound;  //For array[0..n-1] this is "n" not "n-1".

    //CLASS INV: frontSpace indicates first empty cell for pushFront
    //           rearSpace designates rear item (not space) for popRear---
    //           ---or if there is no such item, rearSpace == frontItem;
public:
    StringDeque(int guaranteedCapacity):
	elements(new vector<string>(2*guaranteedCapacity)),
	frontItem(guaranteedCapacity),
	rearSpace(guaranteedCapacity),
	upperBound(2*guaranteedCapacity)
    {
    }

    ~StringDeque() {delete(elements);}

    virtual bool empty() const {
	return frontItem == rearSpace;
    }

    virtual bool full() const {
	return rearSpace == upperBound || frontItem == 0;
    }

    virtual int size() const {
	return rearSpace - frontItem;
    }

    virtual string popRear() {
	if (empty()) {
	    cerr << "Later we'll define and throw an EmptyQException" << endl;
	    return "";
	} else {
	    return elements->at(--rearSpace);
	}
    }

    virtual string popFront() {
	if (empty()) {
	    cerr << "Later we'll define and throw an EmptyQException" << endl;
	    return "";
	} else {
	    return elements->at(frontItem++);
	}
    }

    /** Directions include similarly testing for "full" in the C++ code.
     */
    virtual void pushFront(string newItem)
    {
	if(full()) {
	    cerr << "Later we'll define and throw an FullQException" << endl;
	} else {
	    elements->at(--frontItem) = newItem;
	}
    }
    virtual void pushRear(string newItem)
    {
	if(full()) {
	    cerr << "Later we'll define and throw a FullQException" << endl;
	} else {
	    elements->at(rearSpace++) = newItem;
	}
    }


    virtual string toString() {
	string out = "";
	for (int i = frontItem; i < rearSpace; i++) {
	    out += elements->at(i) + " ";
	}
	return out;
    }
};

int main() {
    StringDeque* sd = new StringDeque(100);
    sd->pushFront("oh");
    sd->pushFront("say");
    sd->pushFront("can");
    sd->pushFront("you");
    sd->pushFront("see");
    sd->pushRear("any");
    sd->pushRear("bad bugs");
    sd->pushRear("on");
    sd->pushRear("me?");
    cout << sd->toString() << endl;
    string pop2 = sd->popRear() + " " + sd->popRear();
    cout << pop2 << ", did this print in the right order?" << endl;
    sd->pushFront("I");
    cout << "Final deque: " << sd->toString() << endl;
}
//I have seen no difference between the outputs between the two programs, both compiled and run on Timberlake
