#include<string>
#include<iostream>
#include<fstream>
#include<vector>
#include "PeekDequeTemplateAJC.h"

using namespace std;

bool ed1(const string& x, const string& y) {
    string longString;
    string shortString;
    int edits = 0;

    if(x.length() <= y.length()) {
        longString = y;
        shortString = x;
    } else {
        longString = x;
        shortString = y;
    }

    for(unsigned int i = 0; i < shortString.length(); i++){
        //LOOP INV: Characters < i have been compared
        if(longString.at(i) != shortString.at(i)) {
            //chars differ at index i
            if(longString.length() != shortString.length()) {
                //Strings have an insertion
                //remove extra char from longer string
                longString.erase(i, 1);
                if(longString.at(i) != shortString.at(i)) {
                    edits++;
                }
            }
            edits++;
        }
    }

    //Strings have passed all tests if edits is 0 or 1
    return edits <= 1;
}

bool testChain(PeekDeque<string>* container) {
    //put contents of words.txt into container
    ifstream file("words.txt");
    string buffer;
    while(getline(file, buffer)) {
        container->pushRear(buffer);
    }

    //Test each pair of words in the container
    for(int i = 0; i < container->size() - 1; i++) {
        container->moveToFront();
        for(int j = 0; j < i; j++) {
            container->moveRearward();
        }
        string temp = container->peek();
        container->moveRearward();
        if(!ed1(temp, container->peek())){
            return false;
        }
    }
    return true;
}

int main(int argc, char** argv) {
    PeekDeque<string>* pd = new PeekDeque<string>(100);
    if(testChain(pd)) {
        cout << "Input chain is valid for ed1" << endl;
    } else {
        cout << "Input chain is NOT valid for ed1" << endl;
    }
}
/*
    Having multiple peek indexes would be convenient for an application like this.
    I would have to add more peekIndexN variables to the class to enable this functionality
    in a similar manner to the on already in the file.
    Public peek-index objects would make this convenient.
*/
