/** File "PeekDequeAJC.cpp", by AJC.
Adds peek functionality to StringDeque
 */
#include "PeekDeque2AJC.h"
#include <iostream>
#include <string>
#include <vector>

using namespace std;


//--------- StringDeque declarations -----------
StringDeque::StringDeque(int guaranteedCapacity):
    elements(new vector<string>(2*guaranteedCapacity)),
    frontItem(guaranteedCapacity),
    rearSpace(guaranteedCapacity),
    upperBound(2*guaranteedCapacity){
    }

StringDeque::~StringDeque() {delete(elements);}

bool StringDeque::empty() const {
	return frontItem == rearSpace;
}

bool StringDeque::full() const {
	return rearSpace == upperBound || frontItem == 0;
}

int StringDeque::size() const {
	return rearSpace - frontItem;
}

string StringDeque::popRear() {
	if (empty()) {
	    cerr << "Later we'll define and throw an EmptyQException" << endl;
	    return "";
	} else {
	    return elements->at(--rearSpace);
	}
}

string StringDeque::popFront() {
	if (empty()) {
	    cerr << "Later we'll define and throw an EmptyQException" << endl;
	    return "";
	} else {
	    return elements->at(frontItem++);
	}
}

void StringDeque::pushFront(string newItem){
	if(full()) {
	    cerr << "Later we'll define and throw an FullQException" << endl;
	} else {
	    elements->at(--frontItem) = newItem;
	}

}

void StringDeque::pushRear(string newItem){
	if(full()) {
	    cerr << "Later we'll define and throw a FullQException" << endl;
	} else {
	    elements->at(rearSpace++) = newItem;
	}
}

string StringDeque::toString() {
	string out = "";
	for (int i = frontItem; i < rearSpace; i++) {
	    out += elements->at(i) + " ";
	}
	return out;
}

//-------- PeekDeque Definitions ----------
PeekDeque::PeekDeque(int guaranteedCapacity) : StringDeque(guaranteedCapacity), peekIndex(frontItem) {

}

bool PeekDeque::moveFrontward() {
    if(peekIndex == frontItem)
        return false;
    peekIndex--;
    return true;
}

bool PeekDeque::moveRearward() {
    if(peekIndex == rearSpace + 1)
        return false;
    peekIndex++;
    return true;
}

void PeekDeque::moveToFront() {
    peekIndex = frontItem;
}

void PeekDeque::moveToRear() {
    peekIndex = rearSpace + 1;
}

string PeekDeque::peek() {
    if(empty()) {
        cerr << "Cannot peek when empty!" << endl;
        return "";
    }
    return elements->at(peekIndex);
}

string PeekDeque::popFront() {
    if (empty()) {
        cerr << "Attempt to pop from empty PeekDeque" << endl;
        return "";
    } else {
        return elements->at(frontItem++);
    }
}

string PeekDeque::popRear() {
    if (empty()) {
        cerr << "Attempt to pop from empty PeekDeque" << endl;
        return "";
    } else {
        return elements->at(--rearSpace);
    }
}
