/** File "PeekDequeAJC.cpp", by AJC.
Adds peek functionality to StringDeque
 */

#include <iostream>
#include <string>
#include <vector>

using namespace std;

class StringDeque   //Front of deque is toward 0, but need not be 0.
{
protected:
    vector<string>* elements;
    int frontItem;   //CLASS INV: indexes item with least index
    int rearSpace;   //CLASS INV: indexes space after item with greatest index
    int upperBound;  //For array[0..n-1] this is "n" not "n-1".

    //CLASS INV: frontSpace indicates first empty cell for pushFront
    //           rearSpace designates rear item (not space) for popRear---
    //           ---or if there is no such item, rearSpace == frontItem;
public:
    StringDeque(int guaranteedCapacity):
	elements(new vector<string>(2*guaranteedCapacity)),
	frontItem(guaranteedCapacity),
	rearSpace(guaranteedCapacity),
	upperBound(2*guaranteedCapacity)
    {
    }

    ~StringDeque() {delete(elements);}

    virtual bool empty() const {
	return frontItem == rearSpace;
    }

    virtual bool full() const {
	return rearSpace == upperBound || frontItem == 0;
    }

    virtual int size() const {
	return rearSpace - frontItem;
    }

    virtual string popRear() {
	if (empty()) {
	    cerr << "Later we'll define and throw an EmptyQException" << endl;
	    return "";
	} else {
	    return elements->at(--rearSpace);
	}
    }

    virtual string popFront() {
	if (empty()) {
	    cerr << "Later we'll define and throw an EmptyQException" << endl;
	    return "";
	} else {
	    return elements->at(frontItem++);
	}
    }

    /** Directions include similarly testing for "full" in the C++ code.
     */
    virtual void pushFront(string newItem)
    {
	if(full()) {
	    cerr << "Later we'll define and throw an FullQException" << endl;
	} else {
	    elements->at(--frontItem) = newItem;
	}
    }
    virtual void pushRear(string newItem)
    {
	if(full()) {
	    cerr << "Later we'll define and throw a FullQException" << endl;
	} else {
	    elements->at(rearSpace++) = newItem;
	}
    }


    virtual string toString() {
	string out = "";
	for (int i = frontItem; i < rearSpace; i++) {
	    out += elements->at(i) + " ";
	}
	return out;
    }
};

class PeekDeque : public StringDeque {
    int peekIndex;

public:
    PeekDeque(int guaranteedCapacity) : StringDeque(guaranteedCapacity), peekIndex(frontItem) {
    }

    virtual void moveFrontward() {
        if(peekIndex == frontItem)
            return;
        peekIndex--;
    }

    virtual void moveRearward() {
        if(peekIndex == rearSpace + 1)
            return;
        peekIndex++;
    }

    virtual string peek() {
        if(empty()) {
            cerr << "Cannot peek when empty!" << endl;
        }
        return elements->at(peekIndex);
    }

    virtual string popFront() {
        if (empty()) {
            cerr << "Attempt to pop from empty PeekDeque" << endl;
            return "";
        } else {
            return elements->at(frontItem++);
        }
    }

    virtual string popRear() {
        if (empty()) {
            cerr << "Attempt to pop from empty PeekDeque" << endl;
            return "";
        } else {
            return elements->at(--rearSpace);
        }
    }
};

int main() {
    cout << "======= StringDeque =======" << endl;
    StringDeque* sd = new StringDeque(100);
    sd->pushFront("oh");
    sd->pushFront("say");
    sd->pushFront("can");
    sd->pushFront("you");
    sd->pushFront("see");
    sd->pushRear("any");
    sd->pushRear("bad bugs");
    sd->pushRear("on");
    sd->pushRear("me?");
    cout << sd->toString() << endl;
    string pop2 = sd->popRear() + " " + sd->popRear();
    cout << pop2 << ", did this print in the right order?" << endl;
    sd->pushFront("I");
    cout << "Final deque: " << sd->toString() << endl << endl;

    cout << "======= PeekDeque =======" << endl;
    PeekDeque* pd = new PeekDeque(100);
    pd->pushRear("oh");
    pd->pushRear("say");
    pd->pushRear("can");
    pd->pushRear("you");
    pd->pushRear("see");
    pd->pushRear("any");
    pd->pushRear("bad bugs");
    pd->pushRear("on");
    pd->pushRear("me?");
    cout << "Printing words that start with \'s\'" << endl;
    for(int i = 0; i < pd->size(); i++) {
        if(pd->peek().at(0) == 's') {
            cout << pd->peek() << endl;
        }
        pd->moveRearward();
    }
}
//I have seen no difference between the outputs between the two programs, both compiled and run on Timberlake
