/**File UserBaseJJZ.cpp, by Jack Zhan.  Project 2 for CSE250, Spring 2014

 */

#include "UserBaseJJZ.h"

void UserDatabase::insert ( int item_id, int movie_id, int rating ) {
	if ( checkUser(item_id) ) {
		User* person = new User(item_id);
		Udatabase.insert(Udatabase.begin(), person);
	}
	for (itr = Udatabase.begin(); itr != Udatabase.end(); ++itr) {
		if( (*itr)->user_id == item_id ) {
			(*itr)->insert( movie_id, rating );
		}
	}
}

bool UserDatabase::checkUser( int item_id ){
  for (itr = Udatabase.begin(); itr != Udatabase.end(); ++itr){
     if( (*itr)->user_id == item_id ) {
        return false;
     }
  }
  return true;
}

float UserDatabase::getUserAvgRating ( int item_id ) {
  int count = 0, sum = 0;
  map<int,int>::iterator itr2;
  for (itr = Udatabase.begin(); itr != Udatabase.end(); ++itr){
     if( (*itr)->user_id == item_id ) {
        for (itr2 = (*itr)->Reviews.begin(); itr2 != (*itr)->Reviews.end(); ++itr2, ++count){
           sum += itr2->second;
        }
        break;
     }
  }
  float avg = sum / (float)count;
  return avg;
}

float UserDatabase::getMovieAvgRating ( int movie_id ) {
  int count = 0, sum = 0;
  map<int,int>::iterator itr2;
  for (itr = Udatabase.begin(); itr != Udatabase.end(); ++itr){
     for (itr2 = (*itr)->Reviews.begin(); itr2 != (*itr)->Reviews.end(); ++itr2){
        if ( itr2->first == movie_id ) {
           sum += itr2->second;
           count += 1;
           break;
        }
     }
  }
  float avg = sum / (float)count;
  return avg;
}

float UserDatabase::getAllAvgRating () {
  int count = 0, sum = 0;
  map<int,int>::iterator itr2;
  for (itr =Udatabase.begin(); itr !=Udatabase.end(); ++itr){
     for (itr2 = (*itr)->Reviews.begin(); itr2 != (*itr)->Reviews.end(); ++itr2, ++count){
        sum += itr2->second;
     }
  }
  float avg = sum / (float)count;
  return avg;
}

int UserDatabase::getNumRating ( int item_id ) {
  int count = 0;
  for (itr = Udatabase.begin(); itr != Udatabase.end(); ++itr){
     if( (*itr)->user_id == item_id ) {
        count = (*itr)->Reviews.size();
        break;
     }
  }
  return count;
}

void UserDatabase::inputData ( string filename ) {
  int word;
  int counter = 1;
  int item_id; int movie_id; int rating;
  std::ifstream* INFILEp = new std::ifstream(filename.c_str(), std::ios_base::in);
  while ((*INFILEp) >> word) {
     if ( counter == 1 ){
        item_id = word;
     } else if ( counter == 2 ) {
        movie_id = word;
     } else if ( counter == 3 ) {
        rating = word;
        insert ( item_id, movie_id, rating );
     } else {
        counter = 0;
     }
     counter += 1;
  }
  INFILEp->close();
}
