/** File "DequeTestCSP.cpp", by Chris Palmer for CSE250, Spring 2013. For 
Assignment 2.
Translated from "DequeTest.java" into C++ code.

The second line of print out from this code is different from it's Java 
counterpart. The strings "on" and "me?" are switched. My guess is this is due 
to a compiliation 
difference between the Java Compiler and g++ and how they read my code. Java 
dictates left to right, whereas C++ does not guarantee this order

*/

#include <iostream>
#include <string>
#include <vector>

using namespace std;

class DequeTest {

   vector<string>* elements;
   int frontItem;  //CLASS INV: indexes item with the least index
   int rearSpace;  //CLASS INV: indexes space after item with the greatest index
   const int upperBound;  //For array[0..n-1] this is "n" not "n-1".

 public:
   DequeTest(int guaranteedCapacity) : 
                            elements(new vector<string>(2*guaranteedCapacity)),
                            frontItem(guaranteedCapacity),
                            rearSpace(guaranteedCapacity),
                            upperBound(2*guaranteedCapacity){}
   
   virtual bool empty() const {return frontItem==rearSpace;}
   virtual bool full() const {return rearSpace==upperBound||frontItem==0;}
   virtual int size()const{return rearSpace-frontItem;}
   virtual string popRear(){
     if(empty()){
       cerr<<"Later we'll define and throw an EmptyQException"<<endl;
       return "";
    }else {
       return elements->at(--rearSpace);
    }
   }
   virtual string popFront(){
     if(empty()){
       cerr<<"Later we'll define and throw an EmptyQException"<<endl;
       return"";
     }else {
       return elements->at(frontItem++);
     }
   }
   virtual void pushFront(string newItem) {
     elements->at(--frontItem)= newItem;
   }

   virtual void pushRear(string newItem) {
     elements->at(rearSpace++) = newItem;
   }
   virtual string toString() const{
     string out = "";
     for(int i = frontItem; i< rearSpace; i++){
       out += elements->at(i) + " ";
     }
     return out;
   }
};



//Test code
int main(){
  
  DequeTest* dt = new DequeTest(100);
  dt->pushFront("oh");
  dt->pushFront("say");
  dt->pushFront("can");
  dt->pushFront("you");
  dt->pushFront("see");
  dt->pushRear("any");
  dt->pushRear("bad bugs");
  dt->pushRear("on");
  dt->pushRear("me?");
  cout<<dt->toString()<<endl;
  string pop2 = dt->popRear() + " " + dt->popRear();
  cout<< pop2 + ", did this print in the right order?"<<endl;
  dt-> pushFront("I");
  cout<< "Final deque: " + dt->toString()<<endl;

  return(0);
}
