/** File "StackPairCSP.cpp", by Chris Palmer for CSE 250, Spring 2013.
    Provides a template class for a two stack vector which extends from both 
    ends.
*/


#include <iostream>
#include <vector>
using namespace std;
template <class T>
class StackPair {
   vector<T>* elements;
   int frontItem;
   int rearItem;
   int cap;
public:
   StackPair(int gcap);
   bool isEmptyA();
   bool isEmptyB();
   T popA();
   T popB();
   void pushA(T newItem);
   void pushB(T newItem);
   int size();
    ~StackPair(void);
};

template <class T>
StackPair<T>::StackPair(int gcap){
   elements= new vector<T>(gcap);
   frontItem= -1; //INV frontItem==1 designates the initial, empty position
   rearItem=gcap; //INV rearItem==gcap designates the initial, empty position
   cap=gcap;
}

template <class T>
bool StackPair<T>::isEmptyA(){ return frontItem==-1;}

template <class T>
bool StackPair<T>::isEmptyB(){ return rearItem==cap;}

template <class T>
T StackPair<T>::popA(){return elements->at(frontItem--);}

template <class T>
T StackPair<T>::popB(){return elements->at(rearItem++);}

template <class T>
void StackPair<T>::pushA(T newItem){elements->at(++frontItem)=newItem;}

template <class T>
void StackPair<T>::pushB(T newItem){elements->at(--rearItem)=newItem;}

template <class T>
int StackPair<T>::size(){return(frontItem+1+cap-rearItem);}

template<class T>
 StackPair<T>::~StackPair(){delete elements;}
