/*
 * StockSPK.h by Sean Kafer 37654863
 */

#ifndef STOCK_H_
#define STOCK_H_

#include <string>
#include <cmath>
using std::string;
class Stock{

public:
   const string name;
   const size_t capital;
   const double init_price;


   Stock(const string& name, const size_t& capital, const double& init_price)
      :name(name), capital(capital), init_price(init_price){init();}

   Stock()
      :name(""), capital(0), init_price(0.0){init();}


   Stock(const string& name)
      :name(name), capital(0), init_price(0.0){init();}

   Stock(const char* name)
      :name(name), capital(0), init_price(0.0){init();}


   bool operator<(const Stock& rhs) const {
      return name < rhs.name;
   }

   bool operator==(const Stock& rhs) const{
      return name == rhs.name;
   }


   size_t Volume() const{
      return volume;
   }

   double PercentUp() const{
      return percent_up;
   }

   double PercentDown() const{
      return percent_down;
   }

   double PercentChange() const{
      return percent_change;
   }

   double Momentum() const{
      return momentum;
   }

   size_t Trend() const{
      return trend;
   }

   size_t TrendShares() const {
      return trend_shares;
   }

   string str() const {
      return name;
   }
   string hashString() const{
       return name;
   }
   void process_trade(size_t shares, double price){
      prev_price = curr_price;
      curr_price = price;
      volume += shares;
      percent_up = (curr_price - init_price) / init_price * 100.0;
      percent_down = -percent_up;
      percent_change = fabs(percent_up);
      momentum = percent_change * volume / capital;
      if ((trend_sign == +1 && curr_price >= prev_price) ||
         (trend_sign == -1 && curr_price <= prev_price)){

         trend++;
         trend_shares += shares;
      }

      else if (curr_price > prev_price){
         trend = 1;
         trend_shares = shares;
         trend_sign = +1;
      }
      else if (curr_price < prev_price){
         trend = 1;
         trend_shares = shares;
         trend_sign = -1;
      }
      else{
         trend = 0;
         trend_shares = 0;
         trend_sign = 0;
      }
   }


private:
   size_t volume;
   double percent_up;
   double percent_down;
   double percent_change;
   double momentum;
   size_t trend;
   size_t trend_shares;

   double curr_price;
   double prev_price;
   int trend_sign;

   void init(){
      volume = 0;
      percent_up = 0.0;
      percent_down = 0.0;
      percent_change = 0.0;
      momentum = 0.0;
      trend = 0;
      trend_shares = 0;

      curr_price = init_price;
      prev_price = init_price;
      trend_sign = 0;
        }
};



class ProxyVolume{
   

public:
    const Stock* master;
   ProxyVolume(const Stock* pointer)
      :master(pointer){}

   ProxyVolume()
      :master(NULL){}

   ProxyVolume(const ProxyVolume& rhs)
      :master(rhs.master){}

   ProxyVolume& operator=(const ProxyVolume& rhs){
      master = rhs.master;
      return *this;
   }

   const Stock& operator*() const{
      return *master;
   }

   bool operator<(const ProxyVolume& rhs) const{
      return master->Volume() < rhs.master->Volume();
   }

   bool operator==(const ProxyVolume& rhs) const{
      return master->Volume() == rhs.master->Volume();
   }

   string str() const{
      return master->str();
   }
};



class ProxyPercentUp{
   
public:
    const Stock* master;
   ProxyPercentUp(const Stock* pointer): master(pointer){}

   ProxyPercentUp(): master(NULL){}

   ProxyPercentUp(const ProxyPercentUp& rhs) :master(rhs.master){}

   ProxyPercentUp& operator=(const ProxyPercentUp& rhs){
      master = rhs.master;
      return *this;
   }

   const Stock& operator*() const {
      return *master;
   }

   bool operator<(const ProxyPercentUp& rhs)const{
      return master->PercentUp()<rhs.master->PercentUp();
   }

   bool operator==(const ProxyPercentUp& rhs)const{
      return master->PercentUp()==rhs.master->PercentUp();
   }

   string str() const{
      return master->str();
   }
};



class ProxyPercentDown{
   
public:
    const Stock* master;
   ProxyPercentDown(const Stock* pointer): master(pointer){}

   ProxyPercentDown(): master(NULL){}

   ProxyPercentDown(const ProxyPercentDown& rhs)
     :master(rhs.master){}

   ProxyPercentDown& operator=(const ProxyPercentDown& rhs){
      master = rhs.master;
      return *this;
   }

   const Stock& operator*() const {
      return *master;
   }

   bool operator<(const ProxyPercentDown& rhs)const{
      return master->PercentDown()<rhs.master->PercentDown();
   }

   bool operator==(const ProxyPercentDown& rhs)const{
      return master->PercentDown()==rhs.master->PercentDown();
   }

   string str() const{
      return master->str();
   }
};



class ProxyPercentChange{
 
public:
      const Stock* master;
   ProxyPercentChange(const Stock* pointer): master(pointer){}

   ProxyPercentChange(): master(NULL){}

   ProxyPercentChange(const ProxyPercentChange& rhs): master(rhs.master){}

   ProxyPercentChange& operator=(const ProxyPercentDown& rhs){
      master = rhs.master;
      return *this;
   }

   const Stock& operator*() const {
      return *master;
   }

   bool operator<(const ProxyPercentChange& rhs)const{
      return master->PercentChange()<rhs.master->PercentChange();
   }

   bool operator==(const ProxyPercentChange& rhs)const{
      return master->PercentChange()==rhs.master->PercentChange();
      //added parens above CSP
   }

   string str() const{
      return master->str();
   }
};



class ProxyMomentum{
  
public:
     const Stock* master;
   ProxyMomentum(const Stock* pointer): master(pointer){}

   ProxyMomentum(): master(NULL){}

   ProxyMomentum(const ProxyMomentum& rhs): master(rhs.master){}

   ProxyMomentum& operator=(const ProxyMomentum& rhs){
      master = rhs.master;
      return *this;
   }

   const Stock& operator*() const{
      return *master;
   }

   bool operator<(const ProxyMomentum& rhs)const{
      return master->Momentum()<rhs.master->Momentum();
   }

   bool operator==(const ProxyMomentum& rhs)const{
      return master->Momentum()==rhs.master->Momentum();
   }

   string str() const{
      return master->str();
   }
};



class ProxyTrend{
  
public:
     const Stock* master;
   ProxyTrend(const Stock* pointer): master(pointer){}

   ProxyTrend(): master(NULL){}

   ProxyTrend(const ProxyTrend& rhs): master(rhs.master){}

   ProxyTrend& operator=(const ProxyTrend& rhs){
      master=rhs.master;
      return *this;
   }

   const Stock& operator*() const{
      return *master;
   }

   bool operator<(const ProxyTrend& rhs)const{
      return master->Trend()<rhs.master->Trend();
   }

   bool operator==(const ProxyTrend& rhs)const{
      return master->Trend()==rhs.master->Trend();
   }

   string str() const{
      return master->str();
   }
};

class ProxyTrendShares{
  
public:
     const Stock* master;
   ProxyTrendShares(const Stock* pointer): master(pointer){}

   ProxyTrendShares(): master(NULL){}

   ProxyTrendShares(const ProxyTrendShares& rhs): master(rhs.master){}

   ProxyTrendShares& operator=(const ProxyTrendShares& rhs){
      master = rhs.master;
      return *this;
   }

   const Stock& operator*() const{
      return *master;
   }

   bool operator<(const ProxyTrendShares& rhs)const{
      return master->TrendShares()<rhs.master->TrendShares();
   }

   bool operator==(const ProxyTrendShares& rhs)const{
      return master->TrendShares()==rhs.master->TrendShares();
   }

   string str() const{
      return master->str();
   }
};



template<class T>
inline bool operator<=(const T& lhs, const T& rhs){
   return lhs < rhs || lhs == rhs;
}

template<class T>
inline bool operator>(const T& lhs, const T& rhs){
   return !(lhs <= rhs);
}

template<class T>
inline bool operator>=(const T& lhs, const T& rhs){
   return lhs > rhs || lhs == rhs;
}

template<class T>
inline bool operator!=(const T& lhs, const T& rhs){
   return !(lhs == rhs);
}

#endif



