/** File "wordturnCSP.cpp" by Chris Palmer for CSE 250, Spring 2013. Provides a
    main method which uses the data structure defined from TwoStacksCSP in order
    to reverse the front half and rear half of a word. If a word has an odd 
    number of letters, the middle letter is designated to be a part of the rear
    half. Example: input(123454321)->output(4332112345)
*/

#include "TwoStacksCSP.h"

int main(int argc, char* argv[]){
   if (argc>1){
      string input(argv[1]);
      int l = input.length();
      TwoStacks stack(l);
      for(int i=0; i<(l/2);i++){ //Loop INV pushes only the first half of the
         stack.pushA(input[i]);  //input into the stack
      }
      for(int i=(l/2);i<l;i++){  //Loop INV pushes only the rear half of the 
         stack.pushB(input[i]);  //input into the stack
      }
      while(!stack.isEmptyA()){  //Loop INV pops the first half of the stack
         cout<<stack.popA();     //when there are letters to pop. Pops in 
      }                          //reverse order of push
      while(!stack.isEmptyB()){  //Loop INV pops the rear half of the stack 
         cout<<stack.popB();     //when there are letters to pop. Pops in
      }                          //reverse order of the push
      cout<<endl;
   }
   return 0;
}


