/* dictlookupGS.cpp
 * Gagandip  Singh 
 * CSE 250 a7 - 3/29/2013
*/

#import <iostream>
#include <fstream>
#import "ValliGS.h"
#import "StackPairGS.h"
#include <cmath>
#include <vector>
#include <algorithm> 
#include <ctime>

using namespace std;

static StackPair<char> *ts = new StackPair<char>(50);

string wordTurn(const string& word)
{
	string theword  =  word;
	int letterCount = (int)theword.size();
    
	if (letterCount == 1)
	{
		cout << "input word must be longer than 1 letter." << endl;
		return 0;
	}
    
	//if letterCount is odd, the middle letter will be the new last letter
	int halfway = floor(letterCount/2);
    
	//push first half of the characters into stackA
	for(int i=0; i<halfway; i++){
		ts->pushA(theword[i]);
	}
    
	//push second half of the characters into stackA
	for(int i=halfway; i<letterCount; i++){
		ts->pushB(theword[i]);
	}
    
	//re-assemble 1st half
	char* newword = new char[letterCount];
	for(int i=0; i<halfway; i++){
		newword[i] = ts->popA();
	}
    
	//re-assemble 2nd half
	for(int i=halfway; i<letterCount; i++){
		newword[i] = ts->popB();
	}
    
	//cout << "the new word is " << newword << endl;
	return newword;
}

/** Return word if word found, else return "".  Hence REQ: word != ""
 We could make a bool return instead, but in later applications we
 will prefer to return an *iterator* to the found word, or end if none.
 REQ: words sorted by <.  Assumes trichotomy of operator< on strings.
 
 this method written by Dr. Regan
 */
string binsearch(const vector<string>& words, const string& word)
{
    size_t left = 0;
    size_t right = words.size();
    //INV: left's word <= word < right's word, or right == end.
    while (right > left + 1) {
        size_t mid = (right + left)/2;  //integer division
        //INV: mid < right, so mid is always a valid location
        if (word < words.at(mid)) {
            right = mid;
        } else {
            left = mid;
        }
    }
    if (word == words.at(left)) {
        return word;
    } else {
        return "";
    }
}

int main(int argc, const char* argv[])
{
    clock_t time_a = clock();
    cout << "Starting..." << endl;
    
	if (argc == 1 || argc > 2) //argc must == 2 (1 for progname, 1 for input-file)
	{
		cerr << "Usage: " << argv[0] << " input-file" << endl;
		return 0;
	}

	string filename = argv[1];
	
	ifstream inf(filename.c_str());
	ofstream outf("pairs.txt");
 
    if (!outf)
    {
        cout << "failed to write to pairs.txt" << endl;
        exit(EXIT_FAILURE);
    }
    if (!inf)
    {
        cout << "could not find " << filename << endl;
        exit(EXIT_FAILURE);
    }
    //ENS: top two if's ensure an infile and outfile are available

    vector<string> oldWords;
    Valli<string> newWords;
    
    cout << "starting inserts...";
    //REQ: no blank lines in input file
    int insert = 0;
    while (inf)
    {
        //cout << "insert #: " << insert << endl;
        string aWord;
        getline(inf, aWord);
        string newWord = wordTurn(aWord);
        oldWords.push_back(aWord);
        newWords.insert(newWord);
        insert++;
        //cout << newWord << " added to the newWords vector" << endl;
    }
    cout << "done" << endl;
    inf.close();

    sort(oldWords.begin(), oldWords.end());

    //Strategy (3) "merge" routine---technically it computes the intersection. (written by Dr. Regan)
    cout << "finding matches...";
    vector<string>::const_iterator itr1 = oldWords.begin();
    Valli<string>::iterator itr2 = newWords.begin();
    while (itr1 != oldWords.end() && itr2 != newWords.end()) {
        if (*itr1 < *itr2) {
            ++itr1;
        } else if (*itr1 == *itr2) {
            outf << *itr1 << ", " << wordTurn(*itr2) << endl;
            //note: this is valid only if the "wordTurn" fn is self-inverting!
            ++itr1; ++itr2;
        } else {   //by trichotomy of < on strings, *itr1 > *itr2
            ++itr2;
        }
    }
    cout << "done" << endl;

    outf.close();

	delete[] ts;
    
    clock_t time_b = clock();
    if (time_a == ((clock_t)-1) || time_b == ((clock_t)-1)){
        perror("Unable to calculate elapsed time");
        cout << "done" << endl;
        return 0;
    }
    else{
        unsigned int total_time_ticks = (unsigned int)(time_b - time_a);
        cout << "done after " << total_time_ticks << " ticks" << endl;
        return 0;
    }
}

