/*
written by gagandip singh for cse 250 - 2/8/2013

this program takes an input word and figures out how many modifications (1 for each letter)
are needed to create a palindrome. The program also outputs 1 possible palindrome. 
(the one created by modifing left to right)

loop invariant about the index variables on the characters you are checking for equality:
- leftLetterIndex can never be greater than rightLetterIndex.
*/


#include <iostream>

using namespace std;

int main(int argc, const char * argv[])
{
	if (argc == 1 || argc > 2)
	{
		cerr << "Usage: " << argv[0] << " your_word_here" << endl;
		return 0;
	}

	string theword  =  argv[1];
	int letterCount = theword.size();

	if (letterCount == 1)
	{
		cout << "input word is already a palindrome" << endl;
		return 0;
	}

	int leftLetterIndex  = 0;
	int rightLetterIndex = letterCount - 1;
	int modsNeeded = 0;
	
	while(leftLetterIndex < rightLetterIndex){
		char leftChar  = theword[leftLetterIndex];
		char rightChar = theword[rightLetterIndex];
		if (leftChar != rightChar) modsNeeded++;
		leftLetterIndex++;
		rightLetterIndex--;
	}

	string thewordCopy = theword;
	for (int i = 0; i < modsNeeded; i++)
	{
		thewordCopy[i] = theword[(letterCount-1)-i];
		cout << "modified to: " << thewordCopy << endl;
	}

	cout << "mods needed: " << modsNeeded << endl;
	return 1;
}
