/* dictlookupGS.cpp
 * Gagandip  Singh 
 * CSE 250 a7 - 3/29/2013
*/

#import <iostream>
#include <fstream>
#import "ValliGS.h"
#include <cmath>
#include <vector>
#include <algorithm> 
#include <ctime>

using namespace std;

/** Return word if word found, else return "".  Hence REQ: word != ""
 We could make a bool return instead, but in later applications we
 will prefer to return an *iterator* to the found word, or end if none.
 REQ: words sorted by <.  Assumes trichotomy of operator< on strings.
 
 this method written by Dr. Regan
 */
string binsearch(const vector<string>& words, const string& word)
{
    size_t left = 0;
    size_t right = words.size();
    //INV: left's word <= word < right's word, or right == end.
    while (right > left + 1) {
        size_t mid = (right + left)/2;  //integer division
        //INV: mid < right, so mid is always a valid location
        if (word < words.at(mid)) {
            right = mid;
        } else {
            left = mid;
        }
    }
    if (word == words.at(left)) {
        return word;
    } else {
        return "";
    }
}

int main(int argc, const char* argv[])
{
	if (argc == 1 || argc > 2) //argc must == 2 (1 for progname, 1 for input-file)
	{
		cerr << "Usage: " << argv[0] << " input-file" << endl;
		return 0;
	}
    
	string filename = argv[1];
	
	ifstream inf(filename.c_str());

    if (!inf)
    {
        cout << "could not find " << filename << endl;
        exit(EXIT_FAILURE);
    }
    //ENS: top two if's ensure an infile and outfile are available

    Valli<string> myValli;

    while (inf)
    {
        //cout << "insert #: " << insert << endl;
        string input;
        getline(inf, input);
        if (input.compare(0,7,"insert ") == 0){
            //insert item that starts at position 7
            string item = input.substr(7,input.length());
            myValli.insert(item);
            cout << "inserted " << item << endl;
        }
        else if (input.compare(0,5,"find ") == 0){
            //find item that starts at position 5
            string item = input.substr(5,input.length());
            Valli<string>::iterator finditr = myValli.find(item);
            string foundstr = *finditr;
            if(foundstr.compare(item) == 0){
                cout << "found " << item << endl;   
            }
            else{
                cout << "could not find " << item << endl;   
            }
        }
        else if (input.compare(0,6,"erase ") == 0){
            //insert item that starts at position 6
            string item = input.substr(6,input.length());
            Valli<string>::iterator finditr = myValli.find(item);
            string foundstr = *finditr;
            if(foundstr.compare(item) == 0){
                myValli.erase(finditr);
                cout << "erased " << item << endl;
            }
            else{
                cout << "could not find " << item << endl;
            }
        }
        else if (input.compare(0,5,"print") == 0){
            cout << "list contents: " << myValli.toString() << endl;
        }
        //cout << newWord << " added to the newWords vector" << endl;
    }
    
    inf.close();
    cout << "done" << endl;
}

