#include <iostream>
#include <string>
#include <vector>
using namespace std;
class StringDeque {

 protected:
   vector<string>* elements;
   int frontItem;   // CLASS INV: indexes item with the least index
   int rearSpace;   // CLASS INV: indexes space after item with greatest index
   int upperBound;  //For array[0..n-1] this is "n" not "n-1".

   //CLASS INV: frontSpace indicates first empty cell for pushFront
   //           rearSpace designates rear item (not space) for popRear---
   //           ---or if there is no such item, rearSpace == frontItem;
 public:
   StringDeque(int guaranteedCapacity) : elements(new vector<string>(
         2*guaranteedCapacity)),
      frontItem(guaranteedCapacity), rearSpace(guaranteedCapacity),
      upperBound(2*guaranteedCapacity){}

   virtual bool isEmpty() { return frontItem == rearSpace; }
   virtual bool isFull() { return rearSpace == upperBound || frontItem==0; }
   virtual int size() { return rearSpace - frontItem; }

   virtual string popRear() {
      if(isEmpty()){
         cerr << "Later we'll define and throw an EmptyQException";
         return "";
      } else {
         return elements->at(--rearSpace);
      }
   }

   virtual string popFront(){
      if(isEmpty()){
         cerr << "Later we'll define and throw an EmptyQException";
         return "";
      } else {
         return elements->at(frontItem++);
      }
   }
   /** Directions include similarly testing for "full" in the C++ code.
    */
   virtual void pushFront(string newItem){
      elements->at(--frontItem) = newItem;
   }

   virtual void pushRear(string newItem){
      elements->at(rearSpace++) = newItem;
   }

   virtual string toString(){
      string out = "";
      for (int i = frontItem; i < rearSpace; i++){
         out += elements->at(i) + " ";
      }
      return out;
   }
};
/**
* PeekDeque is a class that inherits StringDeque and has an index
* that is uses to look at the particular item in the StringDeque 
* without removing it
*/
class PeekDeque : public StringDeque{
   int peekIndex; // Index that the peek is looking at
 public:
   PeekDeque (int guaranteedCapacity) 
      : StringDeque(guaranteedCapacity),peekIndex(0)
      {}
   
   /**
   * Moves the index towards the front of the StringDeque
   */
   virtual void moveFrontward(){
      if(peekIndex > 0){
         peekIndex -= 1;
      }
   }

   /**
   * Moves the index towards the back of the StringDeque
   */
   virtual void moveRearward(){
      if(peekIndex > 0 || peekIndex < upperBound-1){
         peekIndex += 1;
      }
   }
  
   /**
   * returns the string at the peek index
   */
   virtual string peek(){
      return elements->at(peekIndex);
   }
   
   // Overriden method
   virtual string popRear() {
      if(isEmpty()){
         cerr << "Attempt to pop from empty PeekDeque";
         return "";
      } else {;
         return elements->at(--rearSpace);
      }
   }

   // Overriden method
   virtual string popFront() {
      if(isEmpty()){
         cerr << "Attempt to pop from empty PeekDeque";
         return "";
      } else {
         return elements->at(rearSpace++);
      }
   }

};

int main(){
   int k = 100;
   PeekDeque* peek = new PeekDeque(k);
   peek->pushFront("sam");
   peek->pushFront("garrett");
   peek->pushRear("sssss");
   peek->pushRear("haima");
   peek->pushFront("sara");
   peek->pushRear("sally");
   peek->pushFront("awesome");
   for (int i = 1; i<(k*2);i++){
      if(peek->peek()[0]=='s'){
         cout<<peek->peek()<<endl;
      }
      peek->moveRearward();
   }
   return(0);
}
