/** File "PeekClientKWR.cpp", by KWR for CSE250, Spring 2014.  
Answer to Assignment 3 (and part of 4) minus separate compilation and makefile.  
For conversion to template code in Assignment 5, converting PeekDequeKWR.cpp
 */

#include <iostream>
#include <string>
#include <vector>
#include <fstream>
#include <sstream>
#include "PeekDeque3INC.h"
#include "FlexArrayINC.h"

using namespace std;

/** Strings lhs and rhs have Hamming distance 1
 */
bool hd1(const string& lhs, const string& rhs) {
   if (lhs.size() != rhs.size()) { return false; }
   //else
   int count = 0;
   for (int i = 0; i < rhs.size(); i++) {
      if (lhs.at(i) != rhs.at(i)) { count++; }
   }
   return count == 1;    //return count <= 1; to include equality.
}

/** Strings lhs and rhs have extension distance 1
    REQ: neither string begins or ends with ASCII NUL, \0.
    Strings differ by end-char delete if-and-only-if extending the shorter one
    by '\0' makes them have Hamming distance 1.  And same for first-char delete.
 */
bool xd1(const string& lhs, const string& rhs) {
   if (lhs.size() == rhs.size()) { 
      return hd1(lhs,rhs); 
   } else if (lhs.size() == 1 + rhs.size()) {
      return hd1(lhs, rhs + string('\0')) || hd1(lhs, string('\0') + rhs);
   } else if (1 + lhs.size() == rhs.size()) {
      return hd1(lhs + string('\0'), rhs) || hd1(string('\0') + lhs, rhs);
   } else {
      return false; //strings differ by 2 or more in length.
   }
}
//Using a REQ to stipulate lhs.size() < rhs.size(0 would save only one
//if-branch and 1 return line.  IMHO not worth it.
      
   
/** Strings lhs and rhs have edit distance 1.  Clean version with no REQ.
 */
bool ed1(const string& lhs, const string& rhs) {
   int left = 0; 
   int right;
   if (lhs.size() == rhs.size()) {
      return hd1(lhs,rhs);
   } else if (lhs.size() == 1 + rhs.size()) {  //check for delete in first string
      //LOOP INV: All chars to left of "left" match, and all to right of "right".
      //Hence an extra char in lhs will eventually give right <= left.
      right = lhs.size() - 1;
      while (left < right && lhs.at(left) == rhs.at(left)) { left++; }
      while (right > left && lhs.at(right) == rhs.at(right-1)) { right--; }
      return right == left;  //all chars matched except this extra one.
   } else if (1 + lhs.size() == rhs.size()) {  //check for delete in first string
      //LOOP INV: All chars to left of "left" match, and all to right of "right".
      //Hence an extra char in rhs will eventually give right <= left.
      right = rhs.size() - 1;
      while (left < right && lhs.at(left) == rhs.at(left)) { left++; }
      while (right > left && lhs.at(right-1) == rhs.at(right)) { right--; }
      return right == left;  //all chars matched except this extra one.
   } else {
      return false;
   }
}


bool isLegalChain(PeekDeque<string>* pd2) {
   string word;
   pd2->setPeekToFront();
   bool legal = true;
   if (pd2->empty()) {
      cout << "File of words was empty." << endl;
      //can count as legal chain, so do nothing.
   } else {
      string prevWord = pd2->peek();
      pd2->moveRearward();
      while (!(pd2->atRear())) {  //LOOP INV: prevWord is previous word
         word = pd2->peek();
         if (!ed1(prevWord,word)) {
            legal = false;
         }
         prevWord = word;
         pd2->moveRearward();
      }
   }
   return legal;  //RULE: every branch of a non-void function needs a return
}
   

 int longestchain(vector<PeekDeque<string>* > pd3){
   int size2=0;
   for(int i = 0;i<pd3.size();i++){
     if (pd3.at(i)->size() > size2){size2 = pd3.at(i)->size();}
   }

}

   

int main(int argc, char** argv) {
     PeekDeque<string>* pd2 = new PeekDeque<string>(100);  //larger, to read longer chains
     string word;
     string infileName;
     ifstream* INFILEp;
     cout<<"RAWR";
    
     vector< PeekDeque<string>* > v1;
     int longestSize = 0;
     string longWords;



   //while(getline(*INFILEp, word)) {     //OK on A4, not on A5
   while ((*INFILEp) >> word) {
     bool addWord = true;
     int max = 100; 
 
     if(word.size() > longestSize){
     longestSize = word.size();
     longWords = word;
     }
    
      for(int i  = 0 ; i<v1.size(); i ++){
           PeekDeque<string>*  pd4 = v1.at(i);

           pd4->setPeekToFront();
           string Front = pd4->peek();

           pd4->SetPeekToRear();
           string Rear = pd4->peek();

           if(pd4->size() >= max) {
              addWord= true;
              break;
           }
           else if(ed1(word, Front)) {
              pd4->pushFront(word);
              addWord = false;
           }
           else if(ed1(word, Rear)) {
              pd4->pushRear(word);
              addWord = false;
           }
      }    
     
       if(addWord) {
         PeekDeque<string>* pd = new PeekDeque<string>(max);
         pd->pushFront(word);
         v1.push_back(pd);
         }
   }

        cout << "Finished reading the file known as: " << infileName << endl;
        cout << "the  Longest Chain: " << longestchain(v1) << " words" << endl;
        cout << " the Longest word is: " << longWords << endl;

        INFILEp->close();
        return 0;
}      
