/**
UserBase.h by INC  37535873  for CSE250, Project 2, Spring 2014

Contains both the UserBase and User classes, as well as the Rating class.
*/

#include <iostream>
#include <string>
#include "MovieBase.h"

using namespace std;
/**
Simply holds a list of each user specified in the data files.
*/
class UserBase {
	vector<User>* users;

   public:
	UserBase()
	 : users(new vector<User>())
	{ }
	
	/**
	Returns the user at a specific index.
	*/
	User at(int i);

	/**
	Reads specified u.user file to generate the list of users
	to be able to link up to the reviews for each movie.
	*/
	void readfile(string filename);
};

/**
Holds the data specific to each user, and mainly
the ratings given by that user.
*/
class User {
	friend class UserBase;

	int userID;
	vector<Rating>* ratings;
	
   public:
	User(int uid)
	 : userID(uid)
	 , ratings(new vector<Rating>())
	{ }
	
	/**
	Inner class that holds all of the data given by
	the user about a particular movie.
	This class will be crucial for the Client to generate
	the top # movie lists based on the calculated
	biased rating.
	*/
	class Rating {
		friend class User;

		int movieID;
		int rating;

		Rating(int mid, int r)
	 	 : movieID(mid)
	 	 , rating(r)
		{ }

		/**
		Returns the reviewed movie's ID.
		*/
		int movieid();

		/**
		Returns the movie rating as given by the
		user it belongs to.
		*/
		int movierating();
	};
	
	/**
	Simple user ID accessor.
	*/
	int id();
	
	/**
	Returns the rating for the movie with a specific ID.
	*/
	Rating rating(int i);
};
