#include <vector>
//using namespace std;

class Heap {

  std::vector<int> stocks;
  void shiftHeap(int d, int h);
  void buildHeap();
  

public:
  //std::vector<int> stocks;
  Heap(){}
  Heap(std::vector<int>& keys) {
    stocks = keys;
    buildHeap();
  }
  void print();
};


       

void shiftHeap(int d, int h) {
  int parent = d;
  while ((parent*2)+1 <= h) {
      	int leftC = (parent * 2) + 1;
	int rightC = leftC + 1;
	int swap = parent;
	if (stocks[swap] < stocks[leftC]) {
	  swap = leftC;
	}
	if ((rightC <= h) && (stocks[swap] < stocks[rightC])) {
	  swap = rightC;
       	}
       	if (swap != parent) {
	  int temp = stocks[parent];
	  stocks[parent] = stocks[swap];
	  stocks[swap] = temp;
	  parent = swap;
	}
	else { break; }
   }
   return;
}

void buildHeap() {
  int size = stocks.size();
  int mid = (size-2)/2;
  while (mid >= 0) {
    shiftHeap(mid, size-1);
    --mid;
  }
  return;
}

