/*Author: Jake Wende
for prof Regan cse250 Assignment
*/

#include <vector>
using namespace std;

template <class T>

class StackPair {
	vector<T> elements; //our "array"
	int rearspace; //first available for top
	int frontspace; //first available for bot

public:
	StackPair(int gc);
	bool isEmpty();
	T popTop();
	T popBot();
	void pushTop(T newi);
	void pushBot(T newi);
};

template <class T>
StackPair<T>::StackPair(int gc) {
	elements = vector<T>(gc);
	rearspace = 0; //initialize as first array index
	frontspace = gc-1; //initalize as last array index
}

template <class T>
bool StackPair<T>::isEmpty() {
	return frontspace == 0;
}

template <class T>
T StackPair<T>::popTop() {
	return elements[--rearspace];
}

template <class T>
T StackPair<T>::popBot() {
	return elements[++frontspace];
}

template <class T>
void StackPair<T>::pushTop(T newi) {
	elements[rearspace++] = newi;
}

template <class T>
void StackPair<T>::pushBot(T newi) {
	elements[frontspace--] = newi;
}















