/*Author: Jake Wende
for prof Regan cse250 Assignment
*/

#include <vector>
using namespace std;

template <class T>

class StackPair {
	vector<T>* elements; //our "array"
	int rearspace; //first available for top
	int frontspace; //first available for bot

public:
	StackPair(int gc);
	~StackPair();
	bool isEmpty();
	T popTop();
	T popBot();
	void pushTop(T newi);
	void pushBot(T newi);
};

template <class T>
StackPair<T>::StackPair(int gc) {
	elements = new vector<T>(gc);
	rearspace = 0; //initialize as first array index
	frontspace = gc-1; //initalize as last array index
}

template <class T>
bool StackPair<T>::isEmpty() {
	return rearspace == 0;
}

template <class T>
T StackPair<T>::popTop() {
	return elements->at(--rearspace);
}

template <class T>
T StackPair<T>::popBot() {
	return elements->at(++frontspace);
}

template <class T>
void StackPair<T>::pushTop(T newi) {
	elements->at(rearspace++) = newi;
}

template <class T>
void StackPair<T>::pushBot(T newi) {
	elements->at(frontspace--) = newi;
}

template <class T>
StackPair<T>::~StackPair() {delete elements;}













