/*Author: Jake Wende
this program takes a command line arg, and prints it inside out, if there is an odd number of chars, the middle one will remain where it is. it uses the twostack implamentation in the header file StackPair.h
*/

#include <iostream>
#include <string>
#include <set>
#include <sstream>
#include <fstream>
#include <cstdlib>
#include "StackPairJWW.h" //modified header file for twostack implimentaion
using namespace std;

string wordTurn(const string& word ) {
	int l=word.length();
	StackPair<char>* stacks = new StackPair<char>(l*2);
	char mid;
	if (l%2==1){
	mid = word.at(l/2);
	}
	for (int i=0; i<l; i++) {
	stacks->pushTop(word.at(i));
	stacks->pushBot(word.at(--l));
	}
	stringstream out;
	int popindex = 0;
	while (!stacks->isEmpty()) {
	out << stacks->popTop();
	popindex++;
	}
	if (l%2==1) { out << mid;}
	while (popindex != 0) {
	out << stacks->popBot();
	popindex--;
	}
return out.str();
}
//you mearly adopted c++, I was born in it, molded by it.
bool binsearch(const vector<string>& words, const string&word){
	string newWord = wordTurn(word);
	int first = 0;
	int last = words.size()-1;
	if (last<first){
		return false;
	}
	if (word.length() > 3) {
		int mid;
		int comp;
		while (first <= last) { //REQ first must be less than last
			mid = (first+last)/2;
			comp = newWord.compare(words[mid]); 
			if (comp==0){return true;}
			// REQ if the words are identical acording to the
			// compare method. returns true.
			if (comp > 0) {first = mid +1;}
			if (comp < 0) {last = mid -1;}
		}
		return false;
	}
}

int main(int argc, char* argv[] ) {
	if (argc == 1){ //REQ if argc is equal to 1, no file was given.
 		cout<<"No input file given."<<endl;
		return 0;
	}
	vector<string> f;
	ifstream fin(argv[1]);
	ofstream pair;
	pair.open("pair.txt");
	string line;

	if (fin.is_open()) {  //REQ if the file is open, keep going.
		while (!fin.eof()) {//INV as long as its not the end of the file
		getline(fin, line);
		f.push_back(line);
		if (binsearch(f,line)){  //REQ if the search determines that a 
			pair<<line<<endl;//word when turned is in the input file
					 // it will add it to pair.txt	
		}
	}

	fin.close();
	pair.close();
	
	}
	else {cout<<"Input file does not exist"<<endl; return 0;}
	
	//string word = wordTurn(argv[1]);
	//cout<<word<<endl;
}



/*the binarysearch method works by sorting a list by a comparison operation that works at best at about O(nlogn). besause the tree height is n, and the weighted tree height of logn, you have O(n)*O(logn)=O(nlogn)

the elements in a set are sorted by a strict weak comparison operation. set containers have a key that allows for direct iteration, which can outway the slower speeds that it has in comparison to unsorted lists.

sort is a function that taked 2 iterators, the start and the end, and performs a comparison on the range of things. front inclusive, end exclusive.
**std::introsort performs at about O(2log2n), then STD runs an insertion sort running at O(n), therfore: O(n)*O(2log2n) = O(nlogn) 


if dict runs at O(1), then it is the clear choice over binarysearch because that is much faster for elements over a few elements.

binarysearch would again be better for smaller sizes, however its hard to beat O(n). 


*/   //added by KWR: student did not terminaten this comment







