/** File "FlexArrayIJH.h", by Jimmy Huang.  Updated for CSE250, Spring 2014
Templated Data-structure file for Project 1.  Students need to add:
(*) Iterator class---in labs from April 8 to 11
(*) Methods T at(int j), iterator insert(iterator pos, const T& newItem), 
iterator erase(iterator pos) due on April 14
(*) Project with expanded client due Mon. April 21.
*/

#ifndef _FLEXARRAY_H_
#define _FLEXARRAY_H

#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include <sstream>
#include <exception>
#include <stdexcept>

using std::vector;
using std::endl;
using std::cerr;
using std::ostringstream;
using std::ostream;
using std::runtime_error;
using std::string;


template <typename T>    //REQ: T has T() and T.str()
class FlexArray;

//template <typename T>
//class FlexArray::iterator;

template <typename T>
class ChunkNode {
  vector<T>* elements;
  ChunkNode<T>* prev;          //optional, to make doubly-linked list

  ChunkNode<T>* next;       //typename is illegal here
  FlexArray<T>* myList;   //unnecessary? 
  size_t mySize;            //INV: # of elements actually stored
  friend class FlexArray<T>;
  friend class FlexArray<T>::iterator;   //begin lab with this line

public:
  ChunkNode<T>(FlexArray<T>* myList, ChunkNode<T>* myPrev,
    ChunkNode<T>* myNext)
    : elements(new vector<T>()), prev(myPrev), next(myNext),
    myList(myList), mySize(0)
  { }
};

template <class T>
class FlexArray {
  ChunkNode<T>* firstNode;
  ChunkNode<T>* endNode;
  size_t nodeCap;
  size_t numNodes;
  //friend class ChunkNode<T>;   //IMHO not necessary

  //CLASS INV: endNode is a dummy node, used as target for iterations.
  //firstNode is a real node only when the FlexArray is nonempty (Optional change)
  //Empty is size() == 0, rather than endNode == firstNode.
  //Note: for empty FlexArray, rbegin() cannot assume endNode->prev is
  //non-NULL.  For empty FlexArray, both begin() and rbegin() should == end()
  //MOST IMPT: every non-dummy node is nonempty---empty elements means de-allocate node.

public:

  explicit FlexArray<T>(size_t nodeCap) 
    : firstNode(new ChunkNode<T>(this,NULL,NULL))
    , endNode(firstNode)
    , nodeCap(nodeCap)
    , numNodes(1)
  { }

  FlexArray<T>()
    : firstNode(new ChunkNode<T>(this,NULL,NULL))
    , endNode(firstNode)
    , nodeCap(40)
    , numNodes(1)
  { }

  virtual ~FlexArray<T>(){}

  class RangeEx : public runtime_error {
  public:
    RangeEx() : runtime_error("Index out of range") { }
    explicit RangeEx(string st) : runtime_error(st) { }
  };

  class iterator {
    const FlexArray<T>* myFlex;
    ChunkNode<T>* node;
    size_t localIndex;

    friend class FlexArray<T>;

    //CLASS INV: end() is a valid fencepost for insert, this forward iterator
    //never has the rend() value, so it always has a non-NULL node value.
    //All iterators except end() are on a valid element.
    //end() has a localIndex of 0, so comparisons with end() are valid.

    iterator(const FlexArray<T>* holder, ChunkNode<T>* node, size_t index)
      : myFlex(holder), node(node), localIndex(index)
    { }
    //default destructor, copy, and assignment are fine for iterator class

  public:
    T& operator*() {
      if (node == NULL || node == myFlex->endNode) {
        throw runtime_error("Attempt to de-reference end iterator");
      } else {
        return node->elements->at(localIndex);
      }
    }

    iterator& operator++() {
      if (node == myFlex->endNode) {
        throw RangeEx("Attempt to move past end position");
      } else if (node == NULL) {   //OK: we allow rend() back in-bounds
        node = myFlex->firstNode; localIndex = 0;
      } else {
        localIndex++;
        if (localIndex == node->mySize) {  //advance to next node
          node = node->next;
          localIndex = 0;  //by CLASS INV, node nonempty so valid element
        }
      }
      return *this;
    }

    iterator operator++(int ignored) {
      iterator copy = *this;
      operator++();
      return copy;
    }

    bool operator==(const iterator& rhs) const {
      return node == rhs.node && localIndex == rhs.localIndex
        && myFlex == rhs.myFlex;  //IMPT after all!
    }

    bool operator!=(const iterator& rhs) const {
      return (!(*this == rhs));
    }
  };

  iterator begin(){
    return iterator(this, firstNode, 0);
  }

  iterator end(){
    return iterator(this, endNode, 0);
  }

  iterator rBegin(){
    return iterator(this, endNode->prev, endNode->prev->mySize - 1);
  }

  //at, insert, erase, operator[] etc. methods go here...

  size_t size() const{
    ChunkNode<T>* currNode = firstNode;
    size_t size = 0;
    while (currNode != endNode){
      size+=currNode->elements->size();
      currNode = currNode->next;
    }
    return size;
  }

  bool empty() const {
    return size() == 0;
  }

  T& at(size_t i) {
    size_t prevSum = 0;
    ChunkNode<T>* currNode = firstNode;
    while (i >= prevSum + currNode->elements->size()){
      prevSum += currNode->elements->size();
      currNode = currNode->next;
    }
    size_t index = i - prevSum;
    return currNode->elements->at(index);
  }

  T& operator[](size_t i) {
    return at(i);
  }

  bool splitNode(iterator here){
    if (here.node->elements->size() == nodeCap){
      ChunkNode<T>* newNode = new ChunkNode<T>(this,here.node,here.node->next);
      newNode->next->prev = newNode;
      here.node->next = newNode;
      numNodes++;
      /**      for (size_t i = nodeCap/2; i < here.node->elements->size(); i++){
      T item = here.node->elements->at(i);
      newNode->elements->insert(newNode->elements->begin(),item);
      }*/
      newNode->elements->insert(newNode->elements->begin(),here.node->elements->begin()+nodeCap/2,here.node->elements->end());
      newNode->mySize=newNode->elements->size();
      here.node->elements->erase(here.node->elements->begin() + nodeCap/2,here.node->elements->end());
	  here.node->mySize=newNode->elements->size();
      return true;
    }
    return false;
  }

  iterator insert(iterator beforeMe, const T& item){
    if (empty()){
      firstNode = new ChunkNode<T>(this,NULL,endNode);
      endNode->prev = firstNode;
      beforeMe = begin();
    }
    size_t i = beforeMe.localIndex;
    typename vector<T>::iterator it = beforeMe.node->elements->begin() + i;
    beforeMe.node->elements->insert(it,item);
	beforeMe.node->mySize++;
    if(splitNode(beforeMe)){
      if (i < nodeCap/2){
        return iterator(this,beforeMe.node,i);
      }
      else{
        return iterator(this,beforeMe.node->next,i-10);
      }
    }
  }

  iterator erase(iterator me){
    size_t i = me.localIndex;
    typename vector<T>::iterator it = me.node->elements->begin() + i;
    me.node->elements->erase(it);
	me.node->mySize--;
    if (me.node->elements->empty()){
      delete me.node;
      numNodes--;
    }
    return iterator(this,me.node,i);
  }

  string toString() {
    if (empty()){
      throw runtime_error("Array is empty");
    }
    else{
      ostringstream OUT;
      for (size_t i = 0;i < size();i++){
        OUT << at(i) << " ";
      }
      return OUT.str();
    }
  }
};

template <typename T>
ostream& operator<< (ostream& out, const FlexArray<T>& ds) {
  out << ds.toString();
  return out;
};
template <typename T>
ostream& operator<< (ostream& out, const FlexArray<T>*& dsp) {
  out << dsp->toString();
  return out;
};

#endif
