/**PeekDeque2JH.cpp by Jimmy Haung for CSE250*/

#include <iostream>
#include <vector>
#include <string>
#include "PeekDeque2JH.h"

using namespace std;

        stringDeque::stringDeque(int guaranteedCapacity) : elements(new vector<string>(guaranteedCapacity*2)){
                frontItemP = &frontItem;
                rearSpaceP = &rearSpace;
                upperBoundP = &upperBound;
                frontItem = guaranteedCapacity;
                rearSpace = guaranteedCapacity;
                upperBound = guaranteedCapacity*2;
        }
        stringDeque::~stringDeque() {delete(elements);}

        bool const stringDeque::empty(){ return (*frontItemP == *rearSpaceP); }

        bool const stringDeque::full(){ return (*rearSpaceP == *upperBoundP || *frontItemP == 0); }

        int stringDeque::size(){ return (*rearSpaceP - *frontItemP); }

        string stringDeque::popRear(){
                if (empty()){
                  cerr << "Can not pop from an empty stack!" << endl;
                  return "";
                }
                else {
                        return (elements->at(--*rearSpaceP));
                }
        }

        string stringDeque::popFront(){
                if (empty()){
                        cerr << "Can not pop from an empty stack!" << endl;
                        return "";
                }
                else {
                        return (elements->at((*frontItemP)++));
                }
        }

        void stringDeque::pushFront(string newItem){ elements->at(--*frontItemP) = newItem; }

        void stringDeque::pushRear(string newItem){ elements->at((*rearSpaceP)++) = newItem; }

        string stringDeque::toString(){
                string out = "";
                for (int i = *frontItemP; i < *rearSpaceP; i++){
                        out += elements->at(i) + " ";
                }
        return out;
        }

//Start peekDeque class

        peekDeque::peekDeque(int guaranteedCapacity):stringDeque(guaranteedCapacity){
                peekIndexP = &peekIndex;
                *peekIndexP = *frontItemP;
        }

        void peekDeque::indexReset(){
                *peekIndexP = *frontItemP;
        }

        string peekDeque::peek(){        //Peeks the Deque with peekIndex on frontSpace
                if (empty()){
                        cerr << "Later we'll define and throw an EmptyQException" << endl;
                return ("");
                }
                else {
                        return elements->at(*peekIndexP);
                }
        }

        void peekDeque::moveFrontWard(){
                if (empty()){
                        cerr << "Later we'll define and throw an EmptyQException" << endl;
                }
                if (*peekIndexP == (*frontItemP)) {
                        cout << "You have hit the top of the deque" << endl;
                }
                else {
                        --*peekIndexP;
                }
        }

        void peekDeque::moveRearWard(){
                if (empty()){
                        cerr << "Later we'll define and throw an EmptyQException" << endl;
                }
                if (*peekIndexP == (*rearSpaceP-1)){
                        cout << "You have hit the bottom of the deque" << endl;
                }
                else {
                        ++*peekIndexP;
                }
        }

        string peekDeque::popRear(){
                if (empty()){
                        cerr << "Attempt to pop from empty PeekDeque." << endl;
                        return ("");
                }
                else {
                        return (elements->at(--*rearSpaceP));
                }
        }

        string peekDeque::popFront(){
                if (empty()){
                        cerr << "Attempt to pop from empty PeekDeque." << endl;
                        return ("");
                }
                else {
                        return (elements->at(*frontItemP++));
                }
        }
