/** File "movieBaseAH.cpp", by Alisa Ho for CSE250, Spring2014 Project2
 */


#include "movieBaseAH.h"
#include <stdlib.h>
#include "movieAH.cpp"
#include "genre.h"


using namespace std;

movieBase::movieBase(){
  readMovieInfo();
}

void movieBase::readMovieInfo(){
    /** This method reads file u.item, takes th year, title, index and genre and assigns it to the movie object, mov.  After, we push it into a vector, movieInfo
     */
    string line[25];
    genre* cgenre;
    cgenre = new genre();
    
    ifstream* data = new ifstream("u.item", ios_base::in);
    while(data->good()){
        movie mov;
        getline(*data, line[0],'|');
        getline(*data, line[1],'|');
        
        getline(*data, line[2],'-');
        getline(*data, line[3],'-');
        getline(*data, line[4],'|');
        
        mov.year = atoi(line[4].c_str());
        getline(*data, line[5],'|');
        getline(*data, line[6],'|');
        getline(*data, line[7],'|');
        
        mov.movieIndex = atoi(line[0].c_str());
        mov.movieTitle = line[1];
        mov.movieGenre = cgenre->getGenre(atoi(line[0].c_str()));
        
        movieInfo.push_back(mov);
        
    }
}
/**Returns the movie title given the movie index*/
string movieBase::getTitle(size_t movieIndex){
    return movieInfo[movieIndex].movieTitle;
}
/**Using a map, we store the all the ratings to its corresponding movie index.  The key is the movie index, with a vector of ratings */

void movieBase::set_rMap(){
    string line[4];
    
    ifstream* data = new ifstream("u.data", ios_base::in);
    while(data->good()){
        getline(*data, line[0],'\t');
        getline(*data, line[1],'\t');
        getline(*data, line[2],'\t');
        getline(*data, line[3],'\t');
        rMap[atoi(line[1].c_str())] = new vector<size_t>;
        rMap[atoi(line[1].c_str())]->push_back(atoi(line[2].c_str()));
    }

/**Here we are calculating the average(rM) for a specific movie.  After we find the average, we push it into a new map called avgMap.  The key is the movie index and the value is the average.*/
//double movieBase::rM(vector<size_t> rate){
    double avg;
    size_t count;
    for(int i = 0; i < rMap[atoi(line[1].c_str())]->size(); i++){
        avg += rMap[atoi(line[1].c_str())]->at(i);
    }
    avg = avg / count;

    movieInfo[atoi(line[1].c_str())].avg = avg;
}
double movieBase::getrM(size_t movieIndex){
    return movieInfo[movieIndex].avg;
}

