/**userBaseJH.cpp by Jimmy Huang for CSE250 SPR'14 PROJECT2*/

#include "userBaseJH.h"
#include "userJH.cpp"
#include "genre.cpp"

using namespace std;

userBase::userBase(){
  readUser();
  readRate();
  set_Genre();
  for(int i = 0;i<users.size();i++){
    users[i].gRateAvg();
  }
  for(int i = 0;i<users.size();i++){
    users[i].prefFactor(1,users[i].gRate);
    users[i].prefFactor(2,users[i].gRate);
    users[i].prefFactor(3,users[i].gRate);
    users[i].prefFactor(4,users[i].gRate);
    users[i].prefFactor(5,users[i].gRate);
    users[i].prefFactor(6,users[i].gRate);
  }
}
/**
Read data file of users and create an object for each and place in the set.
*/
void userBase::readUser(){
  string line;
  ifstream* data = new ifstream("u.user",ios_base::in);
  while(getline(*data,line,'|')){
    user person;
    person.uId = atoi(line.c_str());
    data->ignore('\n');
    users.push_back(person);
  }
}
/**
Read data file of ratings and place them in the map of each user accordingly.
*/
void userBase::readRate(){
  string line[4];
  ifstream* data = new ifstream("u.data",ios_base::in);
  while(getline(*data,line[0],'\t')){
    getline(*data,line[1],'\t');
    getline(*data,line[2],'\t');
    data->ignore('\n');
    users[atoi(line[0].c_str())-1].gRate[atoi(line[1].c_str())] = atoi(line[2].c_str());
    users[atoi(line[0].c_str())-1].set_mRate(atoi(line[1].c_str()),atoi(line[2].c_str()));
  }
}

void userBase::set_Genre(){
  genre* genres = new genre();
  for(int i = 0;i<users.size();i++){
    for(map<size_t,vector<size_t> >::iterator it = users[i].mRate.begin(); it != users[i].mRate.end(); ++it) {
      vector<size_t> temp = genres->getGenre(it->first);
      for (int j = 0;j<temp.size();j++){
        users[i].mRate[it->first].push_back(temp[j]);
      }
    }
  }
}
/**
Get the average rating for a cetrain genere of all its movies.
*/
double userBase::allGRatesAvg(size_t genre){
  double avg;
  size_t count;
  for(int i = 0;i < users.size(); i++){
    if(users[i].gRate.find(genre) != users[i].gRate.end()){
      avg += users[i].gRate[genre];
      count++;
    }
  }
  avgRate[genre]=avg/count;
}

/**
Set the top x movies for a user taking a vector from client code.
*/
/**string userBase::set_top(vector<size_t> movieTop){
movieTop.swap(users[].topMovie);
}*/

user userBase::get_user(size_t person){
  return users[person];
}

/**int main(){
userBase base;
map<size_t,double>::iterator it = base.users[0].gRate.begin();
it++;
cout <<  it->first << "-" << it->second << endl;
map<size_t,vector<size_t> >::iterator its = base.users[0].mRate.begin();
cout << its->second.size() << endl; ;
return 0;
}*/