#include<iostream>
#include<string>
#include<vector>
#include<fstream>
#include<sstream>
#include"PeekDeque3MPH.h"
#include"StringWrap.cpp"
#include"StringWrap.h"

using namespace std;
/*
Author: Mengpei Hu

for Assignment5
This file takes a file name and optionally a number as argument, read the whole file, or if the number provided, read the file for that number of words.
Grow a bunch of word chains with the words read from the file, and finally outputs the longest chain(s) and the chain contains the longest word(s).
*/
bool hd1 (string x, string y){
   int differCounts= 0;
   if(x.length()!=y.length()){
	return false;
   }
   else{
      for(int i=0;i<x.length();i++){
         if(x.at(i)!=y.at(i)){
            differCounts+=1;
         }
      }
   }
   return (differCounts==1);
 }



/*
xd1(): this method works base on the modifying of the line in hd1() that makes it works for the situation that x is same as y.
*/
bool xd1 (const string& x, const string& y){
   if(x.length()==y.length()){
   return hd1(x,y); //if x is never longer than y, then this "if" block will not be needed, so that it saved a call to hd1().
}  else {
   //assign string longer and shorter with corresponding x and y;
   string longer = (x.length()>y.length())? x:y;
   string shorter = (longer==x)? y:x;
   if((longer.length()-shorter.length())!=1){
   return false;
   }   else {
      string cutHead = longer;
      cutHead = cutHead.erase(0,1);
      string cutTail = longer;
      cutTail = cutTail.erase(cutTail.length()-1,1);
      return (hd1(cutHead,shorter) || hd1(cutTail,shorter));

   }
}
}




bool ed1(const string& x, const string& y){
   if(x.empty() ||y.empty()){return false;}
      else if(x.length()==y.length()){
         return hd1(x,y);
   }else {

      string longer = (x.length()>y.length())? x:y;
      string shorter = (longer==x)? y:x;

      if((longer.length()-shorter.length())!=1){
         return false;
       }else {
      int j = 0;
/*  
 the index of the shorter string, if it's the same as the longer string at the corresponding index,
 it increases and do the next comparison of the next index position, 
 if it's not the same as the longer string at the corresponding index, then remains the current value and do the comparison with the longer string in the next index position
*/
      int differCount = 0;
      for(int i = 0; i < longer.length();i++){
	 if(longer[i]==shorter[j]){j++;}
	 else{ differCount++;}
      }
      return(differCount==1);
      }
    }
}




/*
pFix() returns true if the shorter string is the prefix or postfix of the other.
*/
bool pFix(const string& x, const string& y){
   if(x.empty() ||y.empty()){return false;}
   else if(x.length()!=y.length()){
      string longer = (x.length()>y.length())? x:y;
      string shorter = (longer==x)? y:x;
      string tailOfLong = longer.substr(longer.length()-shorter.length());
      string headOfLong = longer.substr(0,shorter.length());
      return(tailOfLong==shorter || headOfLong==shorter);
   }else{return false;}
} 



 
/*
in order to prevent two PeekDeque with only one element that is the same, this method is created.
if the chain contains only one StringWrap and it is same as sw, or the sw.str() is an empty string, this returns true.
*/
bool exist(const StringWrap& sw, PeekDeque<StringWrap> chain){
   if(chain.size()!=1){return false;}
   else if(chain.peek().str()==sw.str()||sw.str()==""){return true;}
   return false;
}
 
bool legalChain(PeekDeque<StringWrap>* pdsw){
   pdsw->setPeekToFront();//reset the index to the begining
   string a = pdsw->peek().str();//getting the first string.
   pdsw->moveRearward();//move Index to obtain b.
   string b = pdsw->peek().str();//obtain the second string.

   for (int i = pdsw->printFrontItem(); i<pdsw->printRearSpace()-1; i++){
      //if client doesn't want a prefix or postfix to be added into the word chain, he or she can delete the "||pfix(a,b)" below.
      if(ed1(a,b)||pFix(a,b)){pdsw->moveRearward();a=b;b=pdsw->peek().str();}
      else {return false;}
   }
   return true;
}
/*
testNewWord(), first fix the Chain's size at the begining by an int preSize to prevent the for loop runs forever since the chains->size() will change over time, 
then initialize 2 temporary PeekDeque<StringWrap>, which will be both assigned the value of chains->at(i) in the for loop,
then push the sw to the front of one and to the rear of the other, 
if the temp PeekDeque are both legal Chain, then assign the one with the word at the rear to Chains->at(i), and the other one will optionally be pushed to Chains as a new element.
if one of them are legalChain, then assign it to Chains->at(i).
if none of them are legalChain, and there are not a PeekDeque that contains only this StringWrap as its element existing in chains.
then initialize the third temp PeekDeque, and push the sw into it, and push this new PeekDeque into chains as a new element.
this will repeat until the sw has tried to attach to every chain the chains has,
if the Chains are empty at the very beginning, then just simply add the sw to a PeekDeque and push it into chains.  
*/
void testNewWord(const StringWrap sw, vector<PeekDeque<StringWrap> >* chains){
    int preSize = chains->size();
    PeekDeque<StringWrap>* pdtemp1 = new PeekDeque<StringWrap>(100);
    PeekDeque<StringWrap>* pdtemp2 = new PeekDeque<StringWrap>(100);
    
    bool added = false;
    if(preSize>0){
       for(int i = 0;i < preSize; i++){
           *pdtemp1 = chains->at(i);
           *pdtemp2 = chains->at(i);
           pdtemp2->pushFront(sw);
           pdtemp1->pushRear(sw);
           if(legalChain(pdtemp1) && legalChain(pdtemp2)){
               chains->at(i) = *pdtemp1;
               /*
               NOTE! if a word can be added into a chain either from front or rear,
               then the line above adds the word to the current chain, and the line below will push a 
               new chain (which is the original chain adds the word from the front)to the chains vector. 
               But very importantly, this will cause some weird result, which will probably create identical chain in the chains. 
               to enable this functionality, delete the // in the line below.
               */
               //chains->push_back(*pdtemp2);  
               added = true;
           }
           else if(legalChain(pdtemp1) && !legalChain(pdtemp2)){
               chains->at(i) = *pdtemp1;
               added = true;
           }
           else if(!legalChain(pdtemp1) && legalChain(pdtemp2)){
               chains->at(i) = *pdtemp2;
               added = true;
           }else if(exist(sw,chains->at(i))){
               added = true;//don't make the chains contain more than one same PeekDeque which only contain one element. 
           }
       }
       if(added==false){
               PeekDeque<StringWrap>* pdtemp3 = new PeekDeque<StringWrap>(100);
               pdtemp3->pushRear(sw);
               chains->push_back(*pdtemp3);
       }else{}
   }else{ 
       PeekDeque<StringWrap>* pdtemp3 = new PeekDeque<StringWrap>(100);
       pdtemp3->pushRear(sw);
       chains->push_back(*pdtemp3);
    }
}



/*
longestChain(), returns a vector<int>*, this vector contains the indexes of the chains that contains the longest chains.
first use a for loop to get the length of the longest chain in this chains vector.
then use the second for loop to add the index of those chains with the longest length to a vector<int>, and return that vector.
*/
vector<int>* longestChain(vector<PeekDeque<StringWrap> >* chains){
   vector<int>* longestIndex = new vector<int>;
   int longest = 0;
   for(int i = 0; i<chains->size();i++){
      if(chains->at(i).size()> longest){
         longest = chains->at(i).size();
      }else{}
   }
    for(int i = 0; i<chains->size();i++){
      if(chains->at(i).size()== longest){
         longestIndex->push_back(i);
      }else{}
   }
   return longestIndex;
}



/*
chainWithLongestWord, returns a vector<int>*, this vector contains the indexes of the chains that contains the chain with longest word.
first use a for loop to get the length of the longest word in this chains vector.
then use the second for loop to add the index of those chains with contains words that has the longest length to a vector<int>, and return that vector
*/
vector<int>* chainWithLongestWord(vector<PeekDeque<StringWrap> >* chains){
   PeekDeque<StringWrap>* pd = new PeekDeque<StringWrap>(100); 
   vector<int>* withWordIndex = new vector<int>();
   int longestWordSize = 0;
   for(int i = 0; i<chains->size();i++){
      *pd = chains->at(i);
      pd->setPeekToFront();
      for(int j = 0;j < pd->size();j++){
         if(pd->peek().str().length()>longestWordSize){
            longestWordSize = pd->peek().str().length();
            if(!(pd->atRear())){
               pd->moveRearward();
            }
         }else if(!(pd->atRear())){
               pd->moveRearward();
            }
      }
   }
   
   for(int i = 0; i<chains->size();i++){
      *pd = chains->at(i);
      pd->setPeekToFront();
      for(int j = 0;j < pd->size();j++){
         if(pd->peek().str().length()==longestWordSize){
            withWordIndex->push_back(i);
            j=pd->size();
         }else if(!(pd->atRear())){
               pd->moveRearward();
          }
      }
   }
   return withWordIndex;
}


int main(int argc, char** argv){
   if(argc==2||argc==3){
      vector<PeekDeque<StringWrap> >* chains= new vector<PeekDeque<StringWrap> >();

      ifstream* input = new ifstream(argv[1], ios::in);

      string temp;
      vector<StringWrap>* swwds = new vector<StringWrap>();
      if(argc==2){
         while(*input >> temp){ 
              swwds->push_back(StringWrap(temp));   
         }
      }
      else{
         int numOfWords = 0;
         stringstream(argv[2])>>numOfWords;
                          
         for(int i = 0; i < numOfWords && *input >> temp;i++){   
            swwds->push_back(StringWrap(temp));
         }
      }
      
      //Notice: When using Hamlet.txt, if you dont want to see the chain with longest word will always to be the first word.
      //the first "word" will be really long, change the initialization of i from 0 to 1 to skip the first "word".
      for(int i = 0; i<swwds->size();i++){
         testNewWord(swwds->at(i),chains);
      }
      int count = 1;

      cout<<"The longest chain is: \n";
      for(int i = 0; i < longestChain(chains)->size();i++){
        cout<<count<<". "<<chains->at(longestChain(chains)->at(i)).toString()<<endl;
        count++;
      }
      
      count= 1;
      cout<<"The chain with longest word is: \n";
      for(int i = 0; i< chainWithLongestWord(chains)->size();i++){
        cout<<count<<". "<<chains->at(chainWithLongestWord(chains)->at(i)).toString()<<endl;
        count++;
      }
      input->close();
   }else{
       cerr<<"usage: <file-name> <words to read> OR <file-name>"<<endl;
       
    }
   return 0;
}
/*
report question: see comment in testNewWord() for how the word chains grows,
see the comment in longestChain() for how the longest chain(s) are being found
see the comment in chainWithLongestWord() for how the chain(s) with longest word are being found.*/
