/** File "DequeTest.java", by KWR for CSE250, Spring 2013.  For 
Assignment 2.  Translate this file into equivalent C++ code.
NOTE: This is different from a similarly-titled assignment in Fall 2010.
 */
//by Mengpei Hu translated to C++ code. 
//import java.io.*;
#include<iostream>
#include<string>


using namespace std;

class StringDeque { //Front of deque is toward 0, but need not be 0.
   string* elements;
   int frontItem;   //CLASS INV: indexes item with least index
   int rearSpace;   //CLASS INV: indexes space after item with greatest index
   int upperBound;  //For array[0..n-1] this is "n" not "n-1".

   //CLASS INV: frontSpace indicates first empty cell for pushFront
   //           rearSpace designates rear item (not space) for popRear---
   //           ---or if there is no such item, rearSpace == frontItem;

   public:
      StringDeque(int guaranteedCapacity): elements(new string[2*guaranteedCapacity]), frontItem(guaranteedCapacity), rearSpace(guaranteedCapacity), upperBound(2*guaranteedCapacity){}
   /** C++ lingo: call the first two "empty" and "full".  Remember "const"!
    */
   const bool isEmpty() { return frontItem == rearSpace; }
   const bool isFull() { return rearSpace == upperBound || frontItem == 0; }
   int size() { return rearSpace - frontItem; }
   
   string popRear() {
      if (isEmpty()) {
         cout<<("Later we'll define and throw an EmptyQException");
         return "";
      } else {
         return elements[--rearSpace];
      }
   }
   string popFront() {
      if (isEmpty()) {
         cout<<("Later we'll define and throw an EmptyQException");
         return "";
      } else {
         return elements[frontItem++];
      }
   }

   /** Directions include similarly testing for "full" in the C++ code.
    */
   void pushFront(string newItem) {
      elements[--frontItem]= newItem;
   }
   void pushRear(string newItem) {
      elements[rearSpace++] = newItem;
   }


   string toString() { 
      string out = "";
      for (int i = frontItem; i < rearSpace; i++) {
         out += elements[i] + " ";
      }
      return out;
   }
};

//public class DequeTest { //later we'll write more-interesting test code
   int main() {
      StringDeque* sd = new StringDeque(100);
      sd->pushFront("oh");
      sd->pushFront("say");
      sd->pushFront("can");
      sd->pushFront("you");
      sd->pushFront("see");
      sd->pushRear("any");
      sd->pushRear("bad bugs");
      sd->pushRear("on");
      sd->pushRear("me?");
      cout<<(sd->toString());
      string pop2 = sd->popRear() + " " + sd->popRear();
      cout<<(pop2 + ", did this print in the right order?");
      sd->pushFront("I");
      cout<<("Final deque: " + sd->toString());
   }

//The output is different between the cpp and java file: the cpp file outputs "on me?" by the value of pop2, but the original java file actually outputs "me? on" for it. I think the reason is because C++ does not have the mandate left-to-right order which java has, such that the same funtion(poprear())in the line will be computer first,and obtain the value of "me?" and "on" at the same time and then  assign the later one("on) to the previous poprear(), and the first one(me?) will be assigned to the later poprear(), such that the pop2 will have value of "on me?" 
