/** File "FlexArrayMPH.h"
    Author: Mengpei Hu
    Template container class FlexArray<T>
    Written for: Project 1
    Base on the outline file given by Prof. KWR in CSE250
 */

#ifndef _FLEXARRAY_H_
#define _FLEXARRAY_H

#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include <sstream>
#include <exception>
#include <stdexcept>

using std::vector;
using std::endl;
using std::cerr;
using std::ostringstream;
using std::runtime_error;

using namespace std;


template <typename T>    //REQ: T has T() and T.str()
class FlexArray;

//template <typename T>
//class FlexArray::iterator;

template <typename T>
class ChunkNode {
   vector<T>* elements;
   ChunkNode<T>* prev;          //optional, to make doubly-linked list

   ChunkNode<T>* next;       //typename is illegal here
   FlexArray<T>* myList;   //unnecessary?
   size_t mySize;            //INV: # of elements actually stored
   friend class FlexArray<T>;
   friend class FlexArray<T>::iterator;   //begin lab with this line

 public:
   ChunkNode<T>(): elements(new vector<T>()), prev(NULL),next(NULL),myList(NULL),mySize(0){}
   ChunkNode<T>(FlexArray<T>* myList, ChunkNode<T>* myPrev,
                                      ChunkNode<T>* myNext)
    : elements(new vector<T>()), prev(myPrev), next(myNext),
      myList(myList), mySize(0)
   { }

   string toString() const {       //Node resemblance to code in Deque<I> class
      ostringstream OUT;
      for(int i = 0; i < elements->size();i++){
        OUT << elements->at(i) << " ";
      }
      return OUT.str();
   }
   size_t size(){
      return elements->size();
   }
   ChunkNode<T>* getNext(){
      return next;
   }
};

template <class T>
class FlexArray {
   ChunkNode<T>* firstNode;
   ChunkNode<T>* endNode;
   size_t nodeCap;
   size_t numNodes;
   friend class ChunkNode<T>;   //IMHO not necessary

   //CLASS INV: endNode is a dummy node, used as target for iterations.
   //firstNode is a real node only when the FlexArray is nonempty (Optional change)
   //Empty is size() == 0, rather than endNode == firstNode.
   //Note: for empty FlexArray, rbegin() cannot assume endNode->prev is
   //non-NULL.  For empty FlexArray, both begin() and rbegin() should == end()
   //MOST IMPT: every non-dummy node is nonempty---empty elements means de-allocate node.

 public:

   explicit FlexArray<T>(size_t nodeCap)
    : firstNode(new ChunkNode<T>(this,NULL,NULL))
    , endNode(new ChunkNode<T>(this,NULL,NULL))
    , nodeCap(nodeCap)
    , numNodes(2)
   {firstNode->next = endNode; endNode->prev = firstNode;}

   FlexArray<T>()
    : firstNode(new ChunkNode<T>(this,NULL,NULL))
    , endNode(new ChunkNode<T>(this,NULL,NULL))
    , nodeCap(40)
    , numNodes(2)
   {firstNode->next = endNode; endNode->prev = firstNode;}

    ~FlexArray<T>(){
      cerr << "This list will self-destruct in 5 nanoseconds..." << endl;
      ChunkNode<T>* current = endNode;
      while (current != firstNode) {
         cerr << "Deleting: " << current->elements << "; ";
         current = current->prev;
         delete(current->next);
      }
      //delete(current);  //do you dare comment this in?
      cerr << "Deleting: " << current->elements << "; done." << endl;
      delete(current);  //i.e. delete(firstNode);
    }

 class iterator {
      friend class FlexArray<T>;
      friend struct ChunkNode<T>;  //needed?


      size_t localIndex;
      FlexArray<T>* myFlex;
      ChunkNode<T>* node;

      explicit iterator(FlexArray<T>* flex, ChunkNode<T>* given, size_t lIndex) : myFlex(flex),node(given),localIndex(lIndex) { }

     public:
      //default copy-ctor and operator= are OK, no destructor needed either
      iterator():myFlex(NULL),node(NULL),localIndex(0){}
      iterator operator=(const iterator& rhs){
        localIndex = rhs.localIndex;
        node = rhs.node;
        myFlex = rhs.myFlex;
        return *this;
      }
      iterator(const iterator& rhs): myFlex(rhs.myFlex),node(rhs.node),localIndex(rhs.localIndex){}

      T& operator*() const {
         if(node == NULL || localIndex == node->size()){throw out_of_range("Passed last item.");}
         else {return node->elements->at(localIndex);}
      }


      iterator& operator++() {
         if(node==NULL || *this == myFlex->end()){
            throw out_of_range("Index at the end.");
         }
         else{
            if(localIndex == node->size()){
               node = node->getNext();
               localIndex=0;
            }
            else{
               localIndex++;
               if(localIndex == node->size()){
                  node = node->getNext();
                  localIndex=0;
               }
            }
         }
         return *this;
      }


      iterator operator++(int x) {
         iterator copy = *this;
         operator++();
         return copy;
      }

      bool operator==(const iterator& rhs) const {
         return node == rhs.node && localIndex == rhs.localIndex && myFlex == rhs.myFlex;
      }

      bool operator!=(const iterator& rhs) const {
         return(!(*this==rhs));
      }

      iterator& nodeNext(){
         node = node->next;
         localIndex = 0;
         return *this;
      }
      ChunkNode<T>* getNode() const {
         return node;
      }
      int getIndex() const{
         return localIndex;
      }
      FlexArray<T>* getFlex() const{
         return myFlex;
      }

   };

   //at, insert, erase, operator[] etc. methods go here...
   iterator begin(){
        return iterator(this, firstNode,0);
   }

   iterator end(){
      return iterator(this,endNode,0);
   }

   iterator rbegin(){
       if(size()!=0){return iterator(this,endNode->prev,endNode->prev->size()-1);}
       else{return begin();cout<<"This is an empty FlexArray!"<<endl;}
   }
   size_t size() {
         size_t count = 0;
         iterator itr = begin();
         while (itr != end()) {
            count++;
            itr++;
         }
         if(firstNode->size() == 0){count--;}
         return count;
   }




   bool empty() const {
      return size() == 0;
   }

   T& at(size_t globalIndex) {
       iterator itr = begin();
       for(int i = 0; i< globalIndex;i++){
          itr++;
       }
       return *itr;
   }

   T& operator[](size_t globalIndex) const{
        return at(globalIndex);
   }

   void split(ChunkNode<T>* nd){
        int halfSize = nd->size() / 2;
        int preSize = nd->size();
        ChunkNode<T>* newnd = new ChunkNode<T>(this,nd,nd->next);
        if(nd->next!=NULL){nd->next->prev = newnd;}
        nd->next=newnd;
        for(int i = halfSize; i<preSize;i++){
            newnd->elements->push_back(nd->elements->at(i));
        }
        for(int i = halfSize; i<preSize;i++){
            nd->elements->pop_back();
        }
   }


   void insert(size_t globalIndex, const T& item){
        iterator itr = begin();
        for(int i = 0; i< globalIndex; i++){
            itr++;
        }
        typename vector<T>::iterator vtitr = itr.node->elements->begin();
        itr.node->elements->insert(vtitr+itr.localIndex, item);
        if(itr.node->size()>nodeCap){
          split(itr.node);
        }
   }

   void erase(size_t globalIndex){
        iterator itr = begin();
        for(int i = 0; i< globalIndex; i++){
            itr++;
        }
        typename vector<T>::iterator vtitr = itr.node->elements->begin();
        itr.node->elements->erase(vtitr+itr.localIndex);
   }


   iterator insert(iterator beforeMe, const T& item){
       if(beforeMe.localIndex==0&&beforeMe.node->prev!=NULL){
            beforeMe.node->prev->elements->push_back(item);
            beforeMe = iterator(this, beforeMe.node->prev, beforeMe.node->prev->size()-1);
       }else{
          typename vector<T>::iterator itr = beforeMe.node->elements->begin();
          beforeMe.node->elements->insert(itr+beforeMe.localIndex, item);
       }

       if(beforeMe.node->size()>nodeCap){
          int preIndex = beforeMe.localIndex;
          int halfSize = beforeMe.node->size()/2;

          split(beforeMe.node);
          if(preIndex>=halfSize){
             int postIndex = preIndex - halfSize;
             beforeMe = iterator(this, beforeMe.node->next, postIndex);
          }else{
             beforeMe = iterator(this, beforeMe.node, preIndex);
          }
       }
    return beforeMe;
   }


   iterator erase(iterator beforeMe){
      typename vector<T>::iterator itr = beforeMe.node->elements->begin();
      beforeMe.node->elements->erase(itr+beforeMe.localIndex);
      if(beforeMe.localIndex == beforeMe.node->size()){beforeMe = beforeMe.nodeNext();}
      return beforeMe;
   }

   string toString(){       //Node resemblance to code in Deque<I> class
      ostringstream OUT;
      FlexArray<T>::iterator itr = begin();
      while (itr != end()) {
         //OUT << current->data << " ";  //REQ of T having operator<< used here.
         //current = current->next;
         OUT << (*itr).str() << " ";
         ++itr;
      }
      return OUT.str();
   }

};
template <typename T>
ostream& operator<< (ostream& out, const FlexArray<T>& ds) {
    out << ds.toString();
    return out;
}
template <typename T>
ostream& operator<< (ostream& out, const FlexArray<T>*& dsp) {
    out << dsp->toString();
    return out;
}

#endif
