/**
   Author: Mengpei Hu
   FlexClient.cpp
   for Project 1 Client file


   This file takes a file name and optionally a number as argument, read the whole file, or if the number provided, read the file for that number of words.
   Grow a bunch of word chains with the words read from the file, and finally outputs the longest chain(s) and the chain contains the longest word(s).
   *also output the chains(s) with greatest growth of word length for project1.

   Note: Be patient when using this client file to read Hamlet.txt, it mat take 1~2 mins.
*/
#include<iostream>
#include<string>
#include<vector>
#include<fstream>
#include<sstream>
//#include"PeekDeque3MPH.h"
#include"StringWrap.cpp"

#include"StringWrap.h"
#include"FlexArray2MPH.h"
using namespace std;

bool hd1 (string x, string y){
   int differCounts= 0;
   if(x.length()!=y.length()){
	return false;
   }
   else{
      for(int i=0;i<x.length();i++){
         if(x.at(i)!=y.at(i)){
            differCounts+=1;
         }
      }
   }
   return (differCounts==1);
 }

/**
xd1(): this method works base on the modifying of the line in hd1() that makes it works for the situation that x is same as y.
*/
bool xd1 (const string& x, const string& y){
   if(x.length()==y.length()){
   return hd1(x,y); //if x is never longer than y, then this "if" block will not be needed, so that it saved a call to hd1().
}  else {
   //assign string longer and shorter with corresponding x and y;
   string longer = (x.length()>y.length())? x:y;
   string shorter = (longer==x)? y:x;
   if((longer.length()-shorter.length())!=1){
   return false;
   }   else {
      string cutHead = longer;
      cutHead = cutHead.erase(0,1);
      string cutTail = longer;
      cutTail = cutTail.erase(cutTail.length()-1,1);
      return (hd1(cutHead,shorter) || hd1(cutTail,shorter));

   }
}
}


bool ed1(const string& x, const string& y){
   if(x.empty() ||y.empty()){return false;}
      else if(x.length()==y.length()){
         return hd1(x,y);
   }else {

      string longer = (x.length()>y.length())? x:y;
      string shorter = (longer==x)? y:x;

      if((longer.length()-shorter.length())!=1){
       return false;
       }else {
      int j = 0;
/**
 the index of the shorter string, if it's the same as the longer string at the corresponding index,
 it increases and do the next comparison of the next index position,
 if it's not the same as the longer string at the corresponding index, then remains the current value and do the comparison with the longer string in the next index position
*/
      int differCount = 0;
      for(int i = 0; i < longer.length();i++){
	     if(longer[i]==shorter[j]){j++;}
         else{ differCount++;}
      }
       return(differCount==1);
      }
    }
}

/**
pFix() returns true if the shorter string is the prefix or postfix of the other.
*/
bool pFix(const string& x, const string& y){
   if(x.empty() ||y.empty()){return false;}
   else if(x.length()!=y.length()){
      string longer = (x.length()>y.length())? x:y;
      string shorter = (longer==x)? y:x;
      string tailOfLong = longer.substr(longer.length()-shorter.length());
      string headOfLong = longer.substr(0,shorter.length());
      return(tailOfLong==shorter || headOfLong==shorter);
   }else{return false;}
}

/**  Return true if sw is already exist in chains.

*/

bool exist(const StringWrap& sw, FlexArray<FlexArray<StringWrap>* >* chains){
   typename FlexArray<StringWrap>::iterator faitr;
   for(int i = 0; i<chains->size();i++){
      faitr = chains->at(i)->begin();
      while(faitr!=chains->at(i)->end()){
         if((*faitr).str()==sw.str()){
            return true;
         }else{faitr++;}
      }
   }
}

/** True if switching 2 adjacent unequal letters in x leaves y.
 */
bool transpose(const string& x, const string& y) {
   if (x.length() != y.length()) { return false; } //test length > 1 not needed
   // else
   int xlenm1 = x.length() - 1;
   for (int i = 0; i < xlenm1; i++) {
      if (x[i] != y[i]) {   //mismatch means transposition must be here; if
                            //rest of strings aren't equal, return false.
         if (x[i] == y[i+1] && x[i+1] == y[i]  //&& x[i] != x[i+1] //not needed
                  && x.substr(i+2) == y.substr(i+2)) {
            //cout << "transpose relevant for x = " << x << ", y = " << y << endl;
            return true;    //^^^
         } else {           //^^^Extra screen feedback good for Assgt. 7; we
            return false;   //could just return the "if" clause & save 6 lines
         }
      }
   } //control here means x == y  OR  mismatch in last char only; either way:
   return false;
}


/** Damerau's distance-one criterion, meaning typo correctable by 1 local edit.
 */
bool dd1(const string& x, const string& y) {
   return ed1(x,y) || transpose(x,y);
}


/** True if two words are either dd1() or pFix()

*/
bool wordChain(const string& x, const string& y){
   return pFix(x,y)||dd1(x,y);
}
/** True if two word are only transpose but not pFix or ed1
*/
bool transOnly(const string& x, const string& y){
   return (transpose(x,y)&&!ed1(x,y)&&!pFix(x,y));
}  

/**
testNewWord(), traversal through a vector/FlexArray which contains FlexArray as its elements,
traversal through the chains once to found the position that the new word should be added to,
and check existence at the same time with this traversal,
after the traversal, insert the word to the first found position,
if not found any position, then make a new chain which contains only this new word,
and add it to the chains container.
*/

void testNewWord(const StringWrap sw, FlexArray<FlexArray<StringWrap>* >* chains){
    int preSize = chains->size();
    if(preSize==0){
       FlexArray<StringWrap>* newfa = new FlexArray<StringWrap>();
       newfa->insert(newfa->begin(),sw);
       chains->insert(chains->begin(),newfa);
    }
    else{
       FlexArray<FlexArray<StringWrap>* >::iterator vtitr = chains->begin();
       FlexArray<FlexArray<StringWrap>* >::iterator vtpos;
       FlexArray<StringWrap>::iterator faitr;
       FlexArray<StringWrap>::iterator pos;
       FlexArray<StringWrap>* tempChain;
       bool found = false;
       bool cFound = false;
       string pre;
       while(vtitr!=chains->end()){
          tempChain = *vtitr;
          faitr = tempChain->begin();
          if((*faitr).str() == sw.str()){return;}
          if(wordChain(sw.str(),(*faitr).str())){
             if(!found){
                 pos = faitr;
                 found = true;
             }
          }


          while(faitr!=tempChain->end()&&faitr!=tempChain->rbegin()){
             pre = (*faitr).str();
             if(wordChain(sw.str(),(*(++faitr)).str())&&wordChain(sw.str(),pre)){
                 if(!found){
                    pos = faitr;
                    found = true;
                 }
             }
             if((*faitr).str() == sw.str()){return;}
          }
          if(faitr == tempChain->rbegin()){
             if((*faitr).str() == sw.str()){return;}
             if(wordChain(sw.str(),(*faitr).str())){
                 if(!found){
                   pos = ++faitr;
                   found =true;
                 }
             }
          }
          if(found&&!cFound){
             vtpos = vtitr;
          }
          vtitr++;
       }
       if(found){
          (*vtpos)->insert(pos,sw);
       }
       else{
          FlexArray<StringWrap>* newfa = new FlexArray<StringWrap>();
          newfa->insert(newfa->begin(),sw);
          chains->insert(chains->end(),newfa);
       }
    }
}


/**
longestChain(), returns a vector, this vector contains the longest chain(s).
*/
vector<FlexArray<StringWrap>* >* longestChain(FlexArray<FlexArray<StringWrap>* >* chains){
   vector<FlexArray<StringWrap>* >* longestIndex = new vector<FlexArray<StringWrap>* >;
   FlexArray<FlexArray<StringWrap>* >::iterator vtitr = chains->begin();
   int longest = 0;
   while(vtitr!=chains->end()){
      if((*vtitr)->size()> longest){
         longest = (*vtitr)->size();
      }
      vtitr++;
   }
   vtitr = chains->begin();
   while(vtitr!=chains->end()){
      if((*vtitr)->size()== longest){
         longestIndex->push_back(*vtitr);
      }
      vtitr++;
   }
   return longestIndex;
}

/**
returns a vector, which contains the chains with longest words.
*/
vector<FlexArray<StringWrap>* >* chainWithLongestWord(FlexArray<FlexArray<StringWrap>* >* chains){
   vector<FlexArray<StringWrap>* >* withWordIndex = new vector<FlexArray<StringWrap>* >();
   FlexArray<StringWrap>* fa;
   int longestWordSize = 0;
   FlexArray<FlexArray<StringWrap>* >::iterator vtitr = chains->begin();
   FlexArray<StringWrap>::iterator faitr;
   while(vtitr!=chains->end()){
      fa = *vtitr;
      faitr = fa->begin();
      while(faitr!=fa->end()){
         if((*faitr).str().length()>longestWordSize){
            longestWordSize = (*faitr).str().length();
         }
         faitr++;
      }
      vtitr++;
   }
   vtitr = chains->begin();
   while(vtitr!=chains->end()){
      fa = *vtitr;
      faitr = fa->begin();
      while(faitr!=fa->end()){
         if((*faitr).str().length()==longestWordSize){
            withWordIndex->push_back(faitr.getFlex());
            break;
         }
         faitr++;
      }
      vtitr++;
   }
   return withWordIndex;
}

/**
returns a vector, which contains the chains with greatest growth.
*/
vector<FlexArray<StringWrap>* >* chainWithGreatestGrowth(FlexArray<FlexArray<StringWrap>* >* chains){
   vector<FlexArray<StringWrap>* >* greatestGrowthChains = new vector<FlexArray<StringWrap>* >();
   FlexArray<StringWrap>* fa;
   int longestWordSize = 0;
   int shortestWordSize = 0;
   int growth = 0;
   FlexArray<FlexArray<StringWrap>* >::iterator vtitr = chains->begin();
   FlexArray<StringWrap>::iterator faitr;
   while(vtitr!=chains->end()){
      fa = *vtitr;
      faitr = fa->begin();
      longestWordSize = (*faitr).str().length();
      shortestWordSize = (*faitr).str().length();
      while(faitr!=fa->end()){

         if((*faitr).str().length()>longestWordSize){
            longestWordSize = (*faitr).str().length();
         }
         else if((*faitr).str().length()<shortestWordSize){
            shortestWordSize = (*faitr).str().length();
         }
         faitr++;
      }
      if(longestWordSize - shortestWordSize>growth){growth = longestWordSize - shortestWordSize;}
      vtitr++;
   }
   vtitr = chains->begin();
   while(vtitr!=chains->end()){
      fa = *vtitr;
      faitr = fa->begin();
      longestWordSize = (*faitr).str().length();
      shortestWordSize = (*faitr).str().length();
      while(faitr!=fa->end()){

         if((*faitr).str().length()>longestWordSize){
            longestWordSize = (*faitr).str().length();
         }
         else if((*faitr).str().length()<shortestWordSize){
            shortestWordSize = (*faitr).str().length();
         }
         faitr++;
      }
      if(growth == longestWordSize - shortestWordSize){greatestGrowthChains->push_back(*vtitr);}
      vtitr++;
   }
   return greatestGrowthChains;
}

vector<FlexArray<StringWrap>* >* greatestTrans(FlexArray<FlexArray<StringWrap>* >* chains){
   vector<FlexArray<StringWrap>* >* chainsWithGreatestTrans = new vector<FlexArray<StringWrap>* >();
   FlexArray<FlexArray<StringWrap>* >::iterator vtitr = chains->begin();
   FlexArray<StringWrap>::iterator faitr1;
   FlexArray<StringWrap>::iterator faitr2;
   int trans = 0;
   int greatestTrans = 0;
   string word1;
   string word2;
   string word3;
   while(vtitr!=chains->end()){
      if((*vtitr)->size()>1){
         faitr1 = (*vtitr)->begin();
         faitr2 = ++((*vtitr)->begin());
         if(transpose((*faitr1).str(),(*faitr2).str())){trans++;}
         faitr1++;faitr2++;

         while(faitr2!=(*vtitr)->rbegin()&&faitr2!=(*vtitr)->end()){
            if(transpose((*faitr1).str(),(*faitr2).str())){
               trans++;
            }
            faitr1++;
            faitr2++;
         }
         if(faitr2==(*vtitr)->rbegin()){
            if(transpose((*faitr1).str(),(*faitr2).str())){
               trans++;
            }
         }
      }
      if(trans>greatestTrans){greatestTrans = trans;}
      trans = 0;
      vtitr++;
   }
   if(greatestTrans==0){return chainsWithGreatestTrans;}
   vtitr = chains->begin();
   while(vtitr!=chains->end()){
      if((*vtitr)->size()>1){
         faitr1 = (*vtitr)->begin();
         faitr2 = ++((*vtitr)->begin());
         if(transpose((*faitr1).str(),(*faitr2).str())){trans++;}
         faitr1++;faitr2++;
         while(faitr2!=(*vtitr)->rbegin()&&faitr2!=(*vtitr)->end()){
            if(transpose((*faitr1).str(),(*faitr2).str())){
               trans++;
            }
            faitr1++;
            faitr2++;
         }
         if(faitr2==(*vtitr)->rbegin()){
            if(transpose((*faitr1).str(),(*faitr2).str())){
               trans++;
            }
         }
      }
      if(trans==greatestTrans){chainsWithGreatestTrans->push_back(*vtitr);}
      trans = 0;
      vtitr++;
   }
   return chainsWithGreatestTrans;
}
int main(int argc, char** argv){
   if(argc==2||argc==3){
      FlexArray<FlexArray<StringWrap>* >* chains= new FlexArray<FlexArray<StringWrap>* >();

      ifstream* input = new ifstream(argv[1], ios::in);

      string temp;
      vector<StringWrap>* swwds = new vector<StringWrap>();
      if(argc==2){
        
         while(*input >> temp){
              swwds->push_back(StringWrap(temp));
              
         }
      }
      else{
         int numOfWords = 0;
         stringstream(argv[2])>>numOfWords;

         for(int i = 0; i < numOfWords && *input >> temp;i++){
            swwds->push_back(StringWrap(temp));
         }
      }

      //Notice: When using Hamlet.txt, if you dont want to see the chain with longest word will always to be the first word.
      //the first "word" will be really long, change the initialization of i from 0 to 1 to skip the first "word".
      for(int i = 0; i<swwds->size();i++){
         testNewWord(swwds->at(i),chains);
      }
      vector<FlexArray<StringWrap>* >* longchain= longestChain(chains);
      vector<FlexArray<StringWrap>* >* longword = chainWithLongestWord(chains);
      vector<FlexArray<StringWrap>* >* grow = chainWithGreatestGrowth(chains);
      vector<FlexArray<StringWrap>* >* trans = greatestTrans(chains);
 
      cout<<"NOTE: "<<endl<<"The following chains has either one of these rules:"<<endl;
      cout<<"1. Two words with ed1() returns true are chained."<<endl;
      cout<<"2. Two words with transpose() returns true are chained."<<endl;
      cout<<"**3. Two words with pFix() returns true are chained.(optional and can be disabled by editing the client file)"<<endl;
      cout<<'\n'<<'\n'<<'\n'<<'\n';
      

      int count = 1;
      cout<<"The longest chain is: \n";

      for(int i = 0; i < longchain->size();i++){
        cout<<count<<". "<<longchain->at(i)->toString()<<endl;
        count++;
      }
      cout<<'\n';


      count= 1;
      cout<<"The chain with longest word is: \n";
      for(int i = 0; i< longword->size();i++){
        cout<<count<<". "<<longword->at(i)->toString()<<endl;
        count++;
      }
      cout<<'\n';



      count= 1;
      cout<<"The chain with greatest growth is: \n";

      for(int i = 0; i< grow->size();i++){
        cout<<count<<". "<<grow->at(i)->toString()<<endl;
        count++;
      }
      cout<<'\n';

      count= 1;
      cout<<"The chain with greatest number of transposition is: \n";
      cout<<"Note: will not output any chain if none of the chain has transposition."<<endl;
      for(int i = 0; i< trans->size();i++){
        cout<<count<<". "<<trans->at(i)->toString()<<endl;
        count++;
      }
      cout<<'\n';

      input->close();

    }else{
       cerr<<"usage: <file-name> <words to read> OR <file-name>"<<endl;

    }
   return 0;
}
/**
report question:
1.Because of the iterator, it is easier to code those strategies because we don't need to take care of the PeekIndex anymore,
all I need to do is to traversal through the container to get the longestChain/chainWithLongestWord.
2.After changed vector<FlexArray<StringWrap>* > to FlexArray<FlexArray<StringWrap>* >,
the running time is more than before. Because comparing to vector,
FlexArray has comparative disadvantage in locating elements, which is essentially important when using as a chain container.
*/
