/** File "DequeTest.java", by KWR for CSE250, Spring 2013.  For 
Assignment 2.  Translate this file into equivalent C++ code.
NOTE: This is different from a similarly-titled assignment in Fall 2010.
 */
//by Mengpei Hu translated to C++ code. 
//import java.io.*;

/*
Assignment 3
Author:Mengpei Hu
id#:50048494
*/


/*
Assignment4
Author: Mengpei Hu
id#: 50048494
changed the usage of string* to vector<string>* for elements
*/
#include<iostream>
#include<string>
#include<vector>
#include<fstream>
using namespace std;

class StringDeque { //Front of deque is toward 0, but need not be 0.

protected:
   vector<string>*  elements;
   int frontItem;   //CLASS INV: indexes item with least index
   int rearSpace;   //CLASS INV: indexes space after item with greatest index
   int upperBound;  //For array[0..n-1] this is "n" not "n-1".

   //CLASS INV: frontSpace indicates first empty cell for pushFront
   //           rearSpace designates rear item (not space) for popRear---
   //           ---or if there is no such item, rearSpace == frontItem;

   public:
      StringDeque(int guaranteedCapacity): elements(new vector<string>(2*guaranteedCapacity)), frontItem(guaranteedCapacity), rearSpace(guaranteedCapacity), upperBound(2*guaranteedCapacity){}
   /** C++ lingo: call the first two "empty" and "full".  Remember "const"!
    */
   const bool isEmpty() { return frontItem == rearSpace; }
   const bool isFull() { return rearSpace == upperBound || frontItem == 0; }
   int size() { return rearSpace - frontItem; }
   
   virtual string popRear() {
      if (isEmpty()) {
         cout<<("Later we'll define and throw an EmptyQException");
         return "";
      } else {
         return elements->at(--rearSpace);
      }
   }
   virtual string popFront() {
      if (isEmpty()) {
         cout<<("Later we'll define and throw an EmptyQException");
         return "";
      } else {
         return elements->at(frontItem++);
      }
   }

   /** Directions include similarly testing for "full" in the C++ code.
    */
   virtual void pushFront(string newItem) {
      elements->at(frontItem)= newItem;
   }
   virtual void pushRear(string newItem) {
      elements->at(rearSpace++) = newItem;
   }


   virtual string toString() { 
      string out = "";
      for (int i = frontItem; i < rearSpace; i++) {
         out += elements->at(i) + " ";
      }
      return out;
   }
};




class PeekDeque : public StringDeque {
    int peekIndex;
    int beginIndex;
    public: 
      
    
    PeekDeque(int guaranteeCapacity):StringDeque(guaranteeCapacity),peekIndex(guaranteeCapacity),beginIndex(guaranteeCapacity) {} 
    
    
    virtual ~PeekDeque(){cout<<"Hi,there!"<<endl; delete(elements);}
	
   
    virtual string popRear(){
        if (isEmpty()){
            cout<<"Attempt to pop from empty PeekDeque"<<endl;
            return "";
        }else{
            peekIndex = rearSpace-1;
            return elements->at(--rearSpace);
        }
    }
        
    virtual string popFront(){
        if (isEmpty()){
            cout<<"Attmept to pop from empty PeekDeque"<<endl;
            return "";
        }else{
            peekIndex = frontItem+1;
            return elements->at(frontItem++);
        }
    }
    virtual void pushFront(string newItem) {
      elements->at(--frontItem)= newItem;
      peekIndex = frontItem;
    }
	
    virtual void pushRear(string newItem) {
      elements->at(rearSpace++) = newItem;
      peekIndex = rearSpace ;
    }
   
    virtual string peek(){
      return elements->at(peekIndex);
    }
    virtual string toString(){
       string out = "";
       for (int i = frontItem; i < rearSpace; i++){
           
            out += elements->at(i) + "";
       }
       return out;
    }
	 
    virtual void moveFrontward(){
	peekIndex--;
    }
    
    virtual void moveRearward(){
	peekIndex++;
    }
    virtual int printIndex(){
      
      return peekIndex;
    }
    virtual int printFrontItem(){
      return frontItem;
    }
    virtual int printRearSpace(){
      return rearSpace;
    }
    virtual void resetIndex(){
      peekIndex = beginIndex;
    }  
};    
