/** File "DequeTest.java", by KWR for CSE250, Spring 2013 and 2014.  For 
Assignment 2.  Translate this file into equivalent C++ code.
NOTE: This is different from a similarly-titled assignment in Fall 2010.
 */

#include <iostream>
#include <string>
#include <vector>
#include "DequeTestMGR.h"

using namespace std;

   /** C++ lingo: call the first two "empty" and "full".  Remember "const"!
    */

   bool StringDeque::empty() const { return frontItem == rearSpace; }
   bool StringDeque::full() const { return rearSpace == upperBound || frontItem == 0; }
   int StringDeque::size() const { return rearSpace - frontItem; }
   
   string StringDeque::popRear() {
      if (empty()) {
         cerr << "Later we'll define and throw an EmptyQException";
         return "";
      } else {
         return elements->at(--rearSpace);
      }
   }

   string StringDeque::popFront() {
      if (empty()) {
         cerr << "Later we'll define and throw an EmptyQException";
         return "";
      } else {
         return elements->at(frontItem++);
      }
   }

   /** Directions include similarly testing for "full" in the C++ code.
    */
   void StringDeque::pushFront(string newItem) {
      if (full()) {
         cerr << "Later we'll define and throw an Exception";
      } else {
         elements->at(--frontItem) = newItem;
      }
   }
	
   void StringDeque::pushRear(string newItem) {
     if (full()) {
         cerr << "Later we'll define and throw an Exception";
     } else {
        elements->at(rearSpace++) = newItem;
     }
   }

   string StringDeque::toString() { 
      string out = "";
      for (int i = frontItem; i < rearSpace; i++) {
         out += elements->at(i) + " ";
      }
      return out;
   }

/*      int main() {
      StringDeque* sd = new StringDeque(100);
      sd->pushFront("oh");
      sd->pushFront("say");
      sd->pushFront("can");
      sd->pushFront("you");
      sd->pushFront("see");
      sd->pushRear("any");
      sd->pushRear("bad bugs");
      sd->pushRear("on");
      sd->pushRear("me?");
      cout << sd->toString();
      string pop2 = sd->popRear() + " " + sd->popRear();
      cout << pop2 + ", did this print in the right order?";
      sd->pushFront("I");
      cout << " Final deque: " + sd->toString();
   }
Everthing is the same between the two programs except for the string pop2. The C++ translation prints "on me?" while the java translation prints "me? on". This is because the Java compiler is made to read the statement from left to right, while the C++ language does not define how the statement should be read. This results in the g++ compiler reading the second popRear() first. */ 
