//Mitchell Rathbun FlexClientMGR.cpp
#include <iostream>
#include <string>
#include <fstream>
#include <sstream>

#include "FlexArrayMGR.h"
#include "StringWrapKWR.h"
#include "StringWrapKWR.cpp"

//This method will output true if the edit distance between the two string 
//passed as arguments is 1. Otherwise it will return false.
bool ed1(const string& xx, const string& yy){
   string x = xx;
   string y = yy;

   /*Initializes 3 count variables to be used when comparing strings that differ   by one in length.*/
   int count=0;
   int count1=0;
   int count2=0;

   //Makes sure x is larger string
   if(y.length()>x.length()){
      string temp=x;
      x=y;
      y=temp;
   }

   //Compares strings of equal length
   /*For this block, count indicates the number 
     of differences by position between the strings
     and must be 1 for the block to return true*/
   if(x.length()==y.length()){ 
      for(int i=0; i<x.length(); i++){
         if(x[i]!=y[i]){
            count++;
         }
      }
      if(count==1){
         return true;
      }
      else{
         return false;
      }
   }

   //Compares strings differing by 1 in length
   /*count indicates the amount of times relatively 
     similar positions in the strings are equal and 
     must be equal to y.length() for the block to be true*/
   /*count1 serves as a way to indicate the first time
     count makes a change*/
   /*count2 indicates whether count has changed atleast
     once or not at all. This will always be a 1 or 0*/
   else if(x.length()-1==y.length()){
      
      int j=0;

      for(int i=0; i<x.length(); i++){
         if((i>0&&count1==count)||count2==1){
            j=i-1;
            count2=1; 
         }
         else if(count1!=count){
            j=i;
            count1=count;
         }
         if(x[i]==y[j]){
            count++;   
         }   
      }  
      if(count==y.length()){
         return true;
      }
      else {return false;}
   }

   //Returns false for all strings differing in length by more than 1
   else{return false;}

   }


/** For each chain, see if we can attach sw's word at front or back.
 */
void testNewWord(const StringWrap& sw, vector<FlexArray<StringWrap>* >* chains){
   bool partOfChain=false;

   if (sw.size() <= 2){ //word too short, so start a new deque
      FlexArray<StringWrap>* fa1=new FlexArray<StringWrap>(100);
      fa1->insert(fa1->end(),sw);
      chains->push_back(fa1);
      return;
   }
   for(int i=0; i<chains->size(); i++){
      if(ed1(sw.str(), chains->at(i)->at(chains->at(i)->size()-1).str())){
         chains->at(i)->insert(chains->at(i)->end(),sw);
         partOfChain=true;   
      }
      else if(ed1(sw.str(),chains->at(i)->at(0).str())){
         chains->at(i)->insert(chains->at(i)->begin(), sw);
         partOfChain=true;
      }
   }
   if(partOfChain==false){//Not part of any current chain so start new deque
      FlexArray<StringWrap>* fa2=new FlexArray<StringWrap>(100);
      fa2->insert(fa2->end(),sw);
      chains->push_back(fa2); 
   }
}


/** For each chain, see if we can attach sw's word at front or back. Add the 
requirement that no word can be repeated in a chain.
 *//*
void testNewWordOptimal(const StringWrap& sw, vector<FlexArray<StringWrap>* >* chains){
   bool partOfChain=true;

   if (sw.size() <= 2){ //word too short, so start a new deque
      FlexArray<StringWrap>* fa1=new FlexArray<StringWrap>(100);
      fa1->insert(fa1->end(),sw);
      chains->push_back(fa1);
      return;
   }

   for(int i=0; i<chains->size(); i++){
      
      if(ed1(sw.str(), chains->at(i)->rbegin().str())){
      for(int j=0; j<chains->at(i)->size(); j++){
         if(chains->at(i)->peek().str()==sw.str()){
            partOfChain=false;
         }
         chains->at(i)->increasePeekIndex();
      }
         if(partOfChain==true){
            chains->at(i)->pushRear(sw);
            partOfChain=false;
         }
      }

      else if(ed1(sw.str(),chains->at(i)->getFront().str())){
            chains->at(i)->setPeekToFront();
      for(int j=0; j<chains->at(i)->size(); j++){
         if(chains->at(i)->peek().str()==sw.str()){
            partOfChain=false;
         }
         chains->at(i)->increasePeekIndex();
      }
         if(partOfChain==true){
            chains->at(i)->pushFront(sw);
            partOfChain=false;
         } 
      }
   }

   if(partOfChain==true){//Not part of any current chain so start new deque
      FlexArray<StringWrap>* fa2=new FlexArray<StringWrap>(100);
      fa2->insert(fa2->end(),sw);
      chains->push_back(fa2);
   }
}
*/
/** For each chain, see if we can attach sw's word at front or back. Add the
requirement that the word must be longer than the word before it at either the 
front or rear.
 *//*
void testNewWordIncreasing(const StringWrap& sw, vector<FlexArray<StringWrap>* >* chains){
   bool partOfChain=false;

   if (sw.size() <= 1){ //word too short, so start a new deque
      FlexArray<StringWrap>* fa1=new FlexArray<StringWrap>(100);
      fa1->pushRear(sw);
      chains->push_back(fa1);
      return;
   }
   for(int i=0; i<chains->size(); i++){
      if(ed1(sw.str(), chains->at(i)->getRear().str())&&(sw.str().size()>chains->at(i)->getRear().str().size())){
         chains->at(i)->pushRear(sw);
         partOfChain=true;
      }
      else if(ed1(sw.str(),chains->at(i)->getFront().str())&&(sw.str().size()>chains->at(i)->getFront().str().size())){
         chains->at(i)->pushFront(sw);
         partOfChain=true;
      }
   }
   if(partOfChain==false){//Not part of any current chain so start new deque
      FlexArray<StringWrap>* pd2=new FlexArray<StringWrap>(100);
      fa2->pushRear(sw);
      chains->push_back(fa2);
   }
}
*/

//Prints out the longest chain
void findLongestChain(vector<FlexArray<StringWrap>* >* chains){
   int longest=0;
   int length=0;

   for(int i=0; i<chains->size(); i++){
      if(chains->at(i)->size()>length){
         length=chains->at(i)->size();
         longest=i;
      }
   }
  
   cout << "The longest chain is: " << chains->at(longest)->toString()<< endl;
}



//Prints out the chain with the longest word
void findLongestWord(vector<FlexArray<StringWrap>* >* chains){

   int longestCount=0;
   int wordLength=0;

   for(int i=0; i<chains->size(); i++){
      for(int j=0; j<chains->at(i)->size(); j++){
         if(chains->at(i)->at(j).size()>wordLength&&chains->at(i)->size()>1){
            wordLength=chains->at(i)->at(j).size();
            longestCount=i;
         }
      }
   }

   cout << "The chain with the longest word is: ";
   cout << chains->at(longestCount)->toString() << endl;
}


int main(int argc, char** argv) {
   vector<FlexArray<StringWrap>* >* chains= new vector<FlexArray<StringWrap>* >();
   string entry;
   int limit=0;
   

   //Reads whole file into chains 
   if(argc == 2){
      string inFileName=argv[1];
      ifstream* InFile=new ifstream(inFileName.c_str(), ios_base::in);
      while(*InFile >> entry){
      StringWrap sw(entry);
      sw.trimNonAlphaNum();
      sw.makeLower();
      testNewWord(sw,chains);
   }
   InFile->close();
   }

   //Reads specified number of words into chains
   if(argc > 2){
      string inFileName=argv[1];
      int count=0;
      int limit=0;
      stringstream(argv[2])>>limit;
      ifstream* InFile=new ifstream(inFileName.c_str(), ios_base::in);
      while((*InFile >> entry)&&(count<limit)){
         StringWrap sw(entry);
         sw.trimNonAlphaNum();
         sw.makeLower();
         testNewWord(sw,chains);
         count++;
      }
      InFile->close();
   }

//   findLongestChain(chains);
//   findLongestWord(chains);
}

/* Initially, I created the method testNewWord in order to sort the file 
into chains. This followed all of the basic outlines given in the assignment.
A new chain was created for any word 2 characters or less, 
and any word with an edit distance of 1 with the front or rear word in a
chain was added to that chain. This led to some pretty long chains, but the 
chains consisted mostly of the same couple words "hopping" back and forth. For 
the method testNewWordOptimal, I added the requirement that for a word to be 
added to a chain, it could not be the same as any other word already in that 
chain. This led to much more interesting chains with varied lengths. However,
the new method usually requires lots of words in the file to create these more
interesting chains. I also created the method testNewWordIncreasing, for which 
I allowed words with 2 letters to be added on to an existing chain, as opposed 
to automatically starting a new chain. I also added the requirement that for a 
word to be added on to a chain, that word had to be larger than the one 
preceding it. This allowed for the chain to grow outward with words of 
increasing size from its middle. While this does lead to some interesting 
chains, the resulting chains are usually even shorter than those of 
TestNewOptimal, and words can be repeated on each side of the initial word.
Overall, I think the method TestNewOptimal creates the best chains, as it 
offers a good mix of varied words and lengths with still reasonably long 
chains. */

