/**------------------------------------------------------------------------
   File "Heap.h", by Qing Liu, referencing Dr.Kenneth Regan's source code in 2009
*///-----------------------------------------------------------------------

#ifndef HEAP_H_
#define HEAP_H_

#include <vector>
#include <string>
#include <iostream>
#include <algorithm>   

using std::vector;
using std::make_heap;
using std::pop_heap;

template <class V, class Comp>  
class Heap {
   Comp comp;
   vector<V*>* proxies;
   vector<V*>* topk;
 public:
   Heap()
    : comp(Comp())
    , proxies(new vector<V*>())
    , topk(new vector<V*>()) 
   { }

   virtual ~Heap() {
      delete(proxies);
      delete(topk);
   }
   void insert(V* ptr) {
      proxies->push_back(ptr);
   }
   vector<V*>* getTop(size_t k) { 
      if (k > proxies->size()) { k = proxies->size(); }
      topk->clear();
      std::make_heap(proxies->begin(), proxies->end(), comp);
      for (int i = 0; i < k; i++) {
         std::pop_heap(proxies->begin(), proxies->end()-i, comp);
      }
      for (int i = 0; i < k; i++) {
         topk->push_back(*(proxies->end()-i-1));
      }
      return topk;
   }
};

#endif

