// Rachel Broardt  CSE250 Spring 2013 Assignment 2

#include<iostream>
#include<vector>
#include<string>

using namespace std;

class StringDeque 
{
	string *elements;
	int frontItem;
	int rearSpace;
	int upperBound;

public:
StringDeque (int guaranteedCapacity) 
{
	elements = new string[2*guaranteedCapacity];
	frontItem = guaranteedCapacity;
	rearSpace = guaranteedCapacity;
	upperBound = 2*guaranteedCapacity;
}

bool empty() const { return frontItem == rearSpace; }
bool full() const { return rearSpace == upperBound || frontItem == 0; }
int size() const { return rearSpace - frontItem; }

string popRear() 
{
	if (empty()) 
	{
	cerr << "Later we'll define and throw an EmptyQException."<< endl;
	return "";
	}
	else 
	{
	return elements[--rearSpace];
	}
}

string popFront() 
{
	if (empty()) 
	{
	cerr << "Later we'll define and throw an EmptyQException."<< endl;
	return "";
	}
	else { return elements[frontItem++]; }
	}

void pushFront(const string& newItem) 
{
	elements[--frontItem] = newItem;
}
void pushRear(const string& newItem) 
{
	elements[rearSpace++] = newItem;
}

string toString() 
{
	string out = "";
	for (int i = frontItem; i < rearSpace; i++) 
	{
	out += elements[i] + " ";
	}
	return out;
}
};

int main() 
{ 
	StringDeque* sd = new StringDeque(100);
	sd->pushFront("oh");
	sd->pushFront("say");
	sd->pushFront("can");
	sd->pushFront("you");
	sd->pushFront("see");
	sd->pushRear("any");
	sd->pushRear("bad bugs");
	sd->pushRear("on");
	sd->pushRear("me?");
	cout<<sd->toString()<<endl;
	string pop2 = sd->popRear() + " " + sd->popRear();
	cout<< pop2 << ", did this print in the right order?" << endl;
	sd->pushFront("I");
	cout << "Final deque: "  << sd->toString() << endl;

return (0);
}

/* The output of the C++ file is mostly the same as the Java file.
The only thing that changed between the two was that the C++ output
swapped the "on" and "me?" words. The line that caused this was the 'string pop2'
line, which the language probably read from right to left, 
resulting in the two being printed out in reverse.*/

