//Rachel Broardt and Caitlin Sicurella

#ifndef Heap_H_
#define Heap_H_
#include <algorithm>
#include <vector>
//#include "Stock.h"

//Make template with function-object parameter?
template<typename I>
class Heap (<I> arr [])
{
	stockHeap[arr]; //original array of stocks from hash?
	vector<I*> stockVec(stockHeap); //vector of pointers to stocks?
	int itemPosition; //where item is being inserted
	itemPosition = 0; //first element
	int parent;
	int child;
	int leftchild;
	int rightchild;
	int maxchild;
	 
	make_heap(stockVec.begin(), stockVec.end());
};

private:

void make_heap(0,stockVec.size())
{
	for (int i = stockVec.size() - 1; i >= 0; i--)
		fix_down(i);
};
void fix_down(int i)
{
	parent = 0;
	while(true)
	{
		leftChild = parent*2 + 1;
                rightChild = leftchild+1;
		if (leftchild >= stockVec.size()
			break;
		if ((rightchild < stockVec.size()) && (stockVec(leftchild) < stockVec(rightchild))
		{
			maxchild = rightchild;
			if (stockVec(parent) < stockVec(maxchild)
			{
				swap(stockVec(parent), stockVec(maxchild));
				parent = maxchild;
			}
		}
		else
			break;
	}
};
void fix_up(int i)
{
	child = stockVec.size()-1;
	parent = (child-1)/2;
	while(parent >= 0 && stockVec(parent) < stockVec(child))
	{
		swap(stockVec(parent), stockVec(child));
		child = parent;
		parent = (child-1)/2;
	}
};
void stock_pop(vector<I*> vec)
{
	stockVec(0) = stockVec(itemPosition--);
	fix_down(0);
};

#endif
