/*  "HeapRC.h" by Raymond Chen, partner: Zeming Liu, CSE250
 
 This file implements the max heap in a way more suitable for the "Stock Market News Service Simulation"
 project with running time of O(n). Instead of maintaining the heap property for each insert, this heap will 
 just insert items like a normal vector. When the max heap property is needed, the make_heap function will be
 called, and it will restore the vector into a max heap.
 
 */


#include <vector>
#include <iostream>
using std::vector;
using std::cout;
using std::endl;

//REQ: T has the general operators (our stock class defines these operators, no need function objects)
template <class T>
class heap {
    vector<T> heap_vector;
public:
    heap():heap_vector(vector<T>(1)) {} // starting index of vector is 1
    
    int get_size() const {
        return heap_vector.size()-1;
    }

    void fix_down(int index) {
        T temp = heap_vector[index];
        while(2*index<=get_size()) {
            int child = 2*index;
            if(child < get_size() && heap_vector[child+1] > heap_vector[child]) {
                child++;
            }
            if(temp>=heap_vector[child]) {
                break;
            }
            heap_vector[index] = heap_vector[child];
            index = child;
        }
        heap_vector[index] = temp;
    }
    
    //restores a vector with max heap property
    void make_heap() {
        for(int index=get_size()/2; index>=1; index--) {
            fix_down(index);
        }
    }
    //pop the max value (should call make_heap before popping)
    T pop_max() {
        T temp = heap_vector[1];
        heap_vector[1] = heap_vector[get_size()];
        heap_vector.pop_back();
        if(get_size() > 0) {
            fix_down(1);
        }
        return temp;
    }
    
    //just insert items in arbituary order(will call make_heap to maintain max heap property)
    void insert(T new_item) {
        heap_vector.push_back(new_item);
    }

    void print() {
        for(int i = 1; i<heap_vector.size(); i++) {
            cout << heap_vector[i] << endl;
        }
    }
};
