/**     "dictintersectRC.cpp", by Raymond Chen  CSE250
    
 This file uses "ValliRC.h", "DList.h", "StackPair.h"(from the previous assignment) to read
 an input .txt file(dictionary) via command-line arguement, and outputs the "pairs.txt" file. The
 "pairs.txt" file will contain pairs of same word(larger than 3 letters). If the word has an odd number
 of letters, the middle letter will be included at the second half.

 */


//  REQ: An input .txt file.
//       The words in the .txt file must be all lowercase
//       the words must be sorted, one word each line.
//       No trailing puntuation or spaces.



//ENS: An output file "pairs.txt".
//     The .txt file will contain pairs of words on each line.


#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <vector>
#include "StackPair.h"
#include "ValliRC.h"

using namespace std;

string wordTurn(const string& word) {
    int j = (int)ceil(word.length()/(double)2);
    int l = j;
    int k = (int)word.length();
    string reverseWord = "";
    StackPair<char> stack(k);
    for(int i=0; i<l; i++){
        stack.pushA(word[i]);
    }
    for(int j=(int)ceil(word.length()/(double)2); j<k; j++){
        stack.pushB(word[j]);
    }
    while(!stack.emptyA()) {
        reverseWord = reverseWord + stack.popA();
    }
    while(!stack.emptyB()) {
        reverseWord = reverseWord + stack.popB();
    }
    return reverseWord;
}


int main(int argc, char* argv[]) {
    if(argc == 0) {
        cout << "No input text file!";
    }
    ifstream in(argv[1]);
    ofstream out("pairs.txt");
    string word;
    vector<string> original_words;
    Valli<string> reversed_words;       //default ratio is 20
    while(in >> word) {
        if(word.length() > 3) {
            original_words.push_back(word);
            string reversed = wordTurn(word);
            reversed_words.insert(reversed);    //INV: sorted
        }
    }
    for(int i=0; i<original_words.size(); i++) {
        string words = original_words[i];
        string re_words = *(reversed_words.find(words));
        if(words == re_words) {
            out << words << '\t' << re_words << endl;
        }
    }
    in.close();
    out.close();
}
