/*      dictlookupRC.cpp by Raymond Chen   CSE250
 Reads a text file(dictionary) and outputs a new text file named "pairs.txt" with pairs
 of word of more than 3 letters, one turned inside out of the other, only if the new word is
 in the dictionary. If the word has odd number of letters, the middle letter will be included
 at the second half. This program uses the template class "StackPair.h" to turn words inside out
 and the binary search to search if the new word is in the text file.
 

REQ: An input .txt file.
     The words in the .txt file must be all lowercase.
     The words must be sorted, one word each line.    
     No trailing punctuation or spaces.


ENS: An output file named "pairs.txt".
     The .txt file will have pairs of word on each line.
 
*/

#include <cstdlib>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>
#include "StackPair.h"
using namespace std;


string wordTurn(const string& word) {
    int j = (int)ceil(word.length()/(double)2);
    int l = j;
    int k = (int)word.length();
    string reverseWord = "";
    StackPair<char> stack(k);

    //LOOP INV: i >= 0
    //          i < l
    //          i increases by 1 for each loop
    //          One item is pushed for each iteration
    for(int i=0; i<l; i++){
        stack.pushA(word[i]);
    }
    //LOOP INV: j < k
    //          j increases by 1 for each loop
    //          One item is pushed for each iteration
    for(int j=(int)ceil(word.length()/(double)2); j<k; j++){
        stack.pushB(word[j]);
    }
    //LOOP INV: Stack is not empty
    while(!stack.emptyA()) {
        reverseWord = reverseWord + stack.popA();
    }
    while(!stack.emptyB()) {
        reverseWord = reverseWord + stack.popB();
    }
    return reverseWord;
}

bool binsearch(const vector<string>& words, const string& word) {
    int left = 0;
    int right = (int)words.size();
    int mid = (left+right)/2;
    
//LOOP INV: The values inside the vector will remain the same.
    while(left < right) {
        if(word < words[mid]){
            right = mid;
        }else if(word > words[mid]){
            left = mid + 1;
        }else{
            return true;
        }
        mid = (left+right)/2;
    }
    return false;
}

int main(int argc, char* argv[]) {
    if(argc == 0){
        cout << "No input text file!";
    }
    ifstream in(argv[1]);
    ofstream out("pairs.txt");
    string word;
    vector<string>* list = new vector<string>(0);
    while(in >> word) {
        if (word.length() > 3){
            list->insert(list->end(), word);
        }
    }
//  LOOP INV: 'i' can never be greater than list's size
//             Values in the vector will remain the same
    for (int i=0; i<list->size(); i++){
        word = list->at(i);
        string reverse = wordTurn(word);
        if(binsearch(*list, reverse)){
            out << word << '\t' << reverse << endl;
        }
    }
    in.close();
    out.close();
    delete list;
}




/*  REPORT QUESTION

First of all, the three methods are faster than linear search, thus its worst case is better than O(n^2).
The function needs to repeat n amount of times and each search runs O(logn), so they run in O(nlogn)
which is way faster than linear search ( O(n^2) ).

(a) This method is better because it looks up a word in O(1) time versus
    the binary search which looks up a word in O(logn).
(b) This function is better since the binary search runs in O(nlogn) which is worst than O(n).
 
 
*/
