

#include <iostream>
using namespace std;
class StringDeque { //Front of deque is toward 0, but need not be 0.
   string* elements;
   int frontItem;   //CLASS INV: indexes item with least index
   int rearSpace;   //CLASS INV: indexes space after item with greatest index
   int upperBound;  //For array[0..n-1] this is "n" not "n-1".

   //CLASS INV: frontSpace indicates first empty cell for pushFront
   //           rearSpace designates rear item (not space) for popRear---
   //           ---or if there is no such item, rearSpace == frontItem;

   public:
 StringDeque(int guaranteedCapacity) {
      elements = new string[2*guaranteedCapacity];
      frontItem = guaranteedCapacity;
      rearSpace = guaranteedCapacity;
      upperBound = 2*guaranteedCapacity;
   }
   /** C++ lingo: call the first two "empty" and "full".  Remember "const"!
    */
~StringDeque(){} 
const  bool isEmpty() { return frontItem == rearSpace; }
  

const  bool isFull() { return rearSpace == upperBound || frontItem == 0; }
   
 int size() { return rearSpace - frontItem; }

   
virtual string popRear() {
      if (isEmpty()) {
         cout << "Later we'll define and throw an EmptyQException" << endl ;
         return "";
      } else {
         return elements[--rearSpace];
      }
   }
  
virtual string popFront() {
      if (isEmpty()) {
         cout << "Later we'll define and throw an EmptyQException" << endl;
         return "";
      } else {
         return elements[frontItem++];
      }
   }
  
virtual void pushFront(string newItem) {
      elements[--frontItem] = newItem;
   }
  
virtual void pushRear(string newItem) {
      elements[rearSpace++] = newItem;
   }



 string toString() {
      string out = "";
      for (int i = frontItem; i < rearSpace; i++) {
         out += elements[i] + " ";
      }
      return out;
   }
};

 

 int main(){ 
      StringDeque sd = StringDeque(100);
      sd.pushFront("oh");
      sd.pushFront("say");
      sd.pushFront("can");
      sd.pushFront("you");
      sd.pushFront("see");
      sd.pushRear("any");
      sd.pushRear("bad bugs");
      sd.pushRear("on");
      sd.pushRear("me?");
      cout << sd.toString() << endl;
      string pop2 = sd.popRear() + " " + sd.popRear();
      cout <<  pop2 << ", did this print in the right order?" << endl;
      sd.pushFront("I");
      cout << "Final deque: " << sd.toString() << endl;
   

 return(0);}
// the difference between the java file and the cpp file was that the 'on' and 'me' were switched around//
