/*
   ta-structure file for Project 1.  Students need to add:
   (*) Iterator class---in labs from April 8 to 11
   (*) Methods T at(int j), iterator insert(iterator pos, const T& newItem),
   iterator erase(iterator pos) due on April 14
   (*) Project with expanded client due Mon. April 21.
   */

#ifndef _FLEXARRAY_H_
#define _FLEXARRAY_H
#endif
#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include <sstream>
#include <exception>
#include <stdexcept>

using std::vector;
using std::endl;
using std::cerr;
using std::ostringstream;
using std::runtime_error;


template <typename T>    //REQ: T has T() and T.str()
class FlexArray;

//template <typename T>
//class FlexArray::iterator;

template <typename T>
class ChunkNode {
	vector<T>* elements;
	ChunkNode* prev;          //optional, to make doubly-linked list

	ChunkNode<T>* next;       //typename is illegal here
	FlexArray<T>* myList;   //unnecessary?
	size_t mySize;            //INV: # of elements actually stored
	friend class FlexArray<T>;
	friend class FlexArray<T>::iterator;   //begin lab with this line

	public:
	ChunkNode<T>(FlexArray<T>* myList, ChunkNode<T>* myPrev,
			ChunkNode<T>* myNext)
		: elements(new vector<T>())
		  ,prev(myPrev)
		  ,next(myNext) 
		  ,myList(myList)
		  ,mySize(0)
	{ }
};

template <class T>
class FlexArray {
	ChunkNode<T>* firstNode;
	ChunkNode<T>* endNode;
	size_t nodeCap;
	size_t numNodes;
	//friend class ChunkNode<T>;   //IMHO not necessary

	//CLASS INV: endNode is a dummy node, used as target for iterations.
	//firstNode is a real node only when the FlexArray is nonempty (Optional change)
	//Empty is size() == 0, rather than endNode == firstNode.
	//Note: for empty FlexArray, rbegin() cannot assume endNode->prev is
	//non-NULL.  For empty FlexArray, both begin() and rbegin() should == end()
	//MOST IMPT: every non-dummy node is nonempty---empty elements means de-allocate node.

	public:

	explicit FlexArray<T>(size_t nodeCap)
		: firstNode(new ChunkNode<T>(this,NULL,NULL))
		  , endNode(firstNode)
		  , nodeCap(nodeCap)
		  , numNodes(1)
	{ }

	FlexArray<T>()
		: firstNode(new ChunkNode<T>(this,NULL,NULL))
		  , endNode(firstNode)
		  , nodeCap(40)
		  , numNodes(1)
	{ }

	class iterator {    

		FlexArray<T>* myList;
		ChunkNode<T>* sinNode;
		size_t myIndex;


		public:
		iterator(FlexArray<T>* list, ChunkNode<T>* node, size_t index)
			: myList(list)
			  , sinNode(node)
			  , myIndex(index)
		{
		 }
	
		T& operator*() const {
			if(sinNode == NULL || sinNode == myList->endNode) {
			
		throw runtime_error("This node is NULL, or at the ending of all nodes in FlexArray2SD.h.");
			}
			return sinNode->elements->at(myIndex);
		}
	
		iterator& operator++() {
			myIndex++;
			if(myIndex == sinNode->elements->size()) {
				sinNode = sinNode->next;
				myIndex = 0;
			}
			return *this;
		}
	
		iterator operator++(int ignored) {
			myIndex++;
			if(myIndex == sinNode->elements->size()) {
				sinNode = sinNode->next;
				myIndex = 0;
			}
			return *this;
		}

	
		bool operator==(const iterator rhs) const {
			return (myIndex == rhs->myIndex && sinNode == rhs->sinNode && myList == rhs->myList);
		}

	
		bool operator!=(const iterator rhs) const {
			return (myIndex != rhs->myIndex || sinNode != rhs->sinNode || myList == rhs->myList);
		}

		ChunkNode<T>* getSinNode() {
			return sinNode;
		}

		size_t getMyIndex() {
			return myIndex;
		}

	};


		bool isTheEnd(iterator it) {
		if(it.getSinNode() == NULL)
			return true;
		return false;
		}


		T wordGet(iterator* it, size_t j) {
		ChunkNode<T>* c = it.getSinNode();
		return c->elements->at(j);
		}
	

		size_t size() {
		size_t add = 1;
		iterator it = begin();
		ChunkNode<T>* c =it.getSinNode();
		while(c != endNode) {
			c = c->next;
			add++;
		}
		return add;
		//returns numNodes;
	 	//while considering the # of ChunkNodes alone
	}  
		//O(n/c) timing



	bool empty() {
		if(firstNode == endNode && firstNode->mySize == 0) { return true; }
		return false;
	}       
		//O(1) timing

	iterator begin(){
		return iterator(this, firstNode, 0);
	}

	iterator end(){
		return iterator(this, endNode, 0);
	}

	iterator rbegin(){
		return iterator(this, endNode->prev, endNode->prev->elements->size()-1);
	}


	T at(iterator it) {
		ChunkNode<T>* c = it.getSinNode();
		size_t index = it.getMyIndex();
		return c->elements->at(index);
	}	

	iterator insert(iterator pos, const T& newItem){
		ChunkNode<T>* current = pos.getSinNode();
		if(empty() && current == endNode){
			current->elements->push_back(newItem);
			current->mySize++;
		} else { 	  
			size_t li = pos.SinIndex();
			current->mySize++;
			typename vector<T>::iterator it = current->elements->begin();
			advance(it, li+1);
			current->elements->insert(it,newItem);
			current->mySize = current->mySize++;
			if(current->mySize == nodeCap){
				split(current);
			}
		}
		return iterator(this,current,current->mySize);
	}

	void split(ChunkNode<T>* current){
		ChunkNode<T>* newNode = new ChunkNode<T>(this, current, current->next);
		if(newNode->next != NULL)
			newNode->next->prev = newNode;
		current->next = newNode;     
		size_t half = current->elements->size()/2; 
		for (size_t i = half; i < current->elements->size(); i++) {
			newNode->elements->push_back(current->elements->at(i));
		}
		for (size_t j = current->elements->size() - 1; j >= half; j--) {
			current->elements->erase(current->elements->begin()+j);
		}
	}	
	iterator erase(iterator pos){
		ChunkNode<T>* c = pos.getSinNode();
		c->elements->erase(c->elements->begin() + pos.getMyIndex());
		c->mySize = c->mySize - 1;
		if(c->mySize < 1) {
			c->prev->next = c->next;
			c->next->prev = c->prev;
			numNodes--;
		}
		 //loses current node when empty 
		return iterator(this, c ,pos.getMyIndex());
	}
};

