
//Check Casing

#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <fstream>
#include <map>
#include <vector>

#include "MovieBaseSDDJB.h"
#include "UserBaseSDDJB.h"

#define MAX_ID 9999   //its ober 9000!!!!!
#define MIN_ID 1000
//high and low limits for ids

using namespace std;

void printMovie(map<int, Movie*> mid, int id) {

	if(mid.find(id) == mid.end()) {
		cout << "Cannot find user with this id" << endl << endl; //if id is out of bounds or that user is not in database
		return;
	}

	Movie *movie = mid[id];
	//movie pointer
	cout << "Movie's  id: " << movie->getID() << endl;
	cout << "Movie's title: " << movie->getTitle() << endl;
	cout << "Movie's  date: " << movie->getDate() << endl;
	cout << "Movie's rating: " << movie->getRating() << "=)" << endl << endl;
	
}  //end print movie
 
void populateMovie(map<int, Movie*> &mid) {
	ifstream fin;
	fin.open("u.item");                 
	if(!fin.good()) {
		cout << "u.item cannot be found" << endl;
		exit(EXIT_FAILURE);
	}

	while(!fin.eof()) {
		char buffer[1024];
		fin.getline(buffer, 1024);
		string tmp = "";
		int count = 0;
		int id;
		string title;
		string date;	
		string website;
		vector<string> genre;
		for(int i = 0; i < strlen(buffer); i++) {
			if(buffer[i] == '|') {
				switch(count) {
					case 0:
						id = atoi(tmp.c_str());
						break;
					case 1:
						title = tmp;
						break;
					case 2:
						date = tmp;
						break;
					case 3:
						break;
					case 4:
						website = tmp;
						break;
					default:
						genre.push_back(tmp);
						break; 
				}
				count++;
				tmp = "";
			}
			else {
				tmp+=buffer[i];
			}
		}
		Movie *movie = new Movie(id, title, date, website, genre);
		mid[id] = movie;
	}
	fin.close();
}   //end of popMovie class
 //i hate netflix now =(.......sorry we hate netflix now =(
void printUser(map<int, User*> uid, int id) {
        if(uid.find(id) == uid.end() || id == 0) {
                cout << "Cannot find a user found with this id" << endl << endl;  //if id is out of bounds or that user id s not in database
                return;
        }
        User *user = uid[id];
        cout << "Users id: " << user->getID() << endl;
        vector<int> g = user->getGenrePref();
        map<int, double> g_r = user->getGenreRating();
        for(int i = 0; i < g.size(); i++) {
                cout << g[i] << ": " << g_r[g[i]] << endl;
        }
        cout << endl;
}//end of printuser


void populateRatings(map<int, User*> uid, map<int, Movie*> mid) {

	ifstream fin;
	fin.open("u.data");//data
	if(!fin.good()) {
		cout << "u.data cannot be found" << endl;
//* This data doesnt exist
		exit(EXIT_FAILURE);//leaves
	}

	int user_id;
	int movie_id
	string tmp;;
	int rating;
	int count = 0;

	while(fin >> tmp) {

		switch(count) {
			case 0:

				user_id = atoi(tmp.c_str());
				count = 1;
				break;
//while count is 1, temp store
			case 1:
				movie_id = atoi(tmp.c_str());
				count = 2;
				break;
			case 2:
				rating = atoi(tmp.c_str());
				count = 3;
				break;
			case 3:
				Movie *movie = mid[movie_id];
				movie->setRating(rating);
				User *user = uid[user_id];
				vector<string> genre = movie->getGenre();
				for(int i = 0; i < genre.size(); i++) {
					if(genre[i] == "1") {
						user->setGenreRating(i, rating);
					}
				}
				count = 0;
				break;
		}
	}
	fin.close(); //closes the fin.
}//end of popratings meth.

void populateUser(map<int, User*> &uid) {

        ifstream fin;
        fin.open("u.user"); //opens up the u.user file

        if(!fin.good()) {
                cout << "u.user cannot be found" << endl;
                exit(EXIT_FAILURE);  
        }

        while(!fin.eof()) {

                char buffer[256];
                fin.getline(buffer, 256);
                string tmp = "";
                for(int i = 0; i < strlen(buffer); i++) {
                        if(!isdigit(buffer[i]))
                                break;
                        tmp += buffer[i];          //updates temp
                }
                int id = atoi(tmp.c_str());
                User *user = new User(id);
                uid[id] = user;
        }
        fin.close();  //closes fin
}   //end of popUser method


//start of main
int main() {
	map<int, User*> idUserMap;
	map<int, Movie*> idMovieMap;

	populateUser(idMovieMap);
	populateMovie(idUserMap);
	populateRatings(idUserMap, idMovieMap);
	
	srand(time(NULL));
	string input = "";
	
	while(input != "x" && input != "X") {
		cout << "Netflix:" << endl;
		cout << "Please Type in the following  \"x\" to exit" << endl;
		cout << "Please Type in the following \"u\" to print user info" << endl;
		cout << "Please Type in the following \"m\" to print movie info" << endl;
		cout << "> ";
		cin >> input;//reads in the input
		cout << endl;   ///skip[ps a line
		if (input == "u" || input == "U") {
			string id = "";                  
			cout << "Enter user id: ";
			cin >> id;                  //reads in and stores the user id
			printUser(idUserMap, atoi(id.c_str()));
		} else if (input == "m" || input == "M") {
			string id = "";
			cout << "Please enter movie id here: ";
			cin >> id;
			printMovie(idMovieMap, atoi(id.c_str()));               //reads in adn stores the movies id number
		} else if (input != "x" && input != "X") {
			cout << "Input is incorrect, Please Try Again" << endl << endl;
		}
	}	
};
//turn up we finished this!!!
